/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimestampType;
import io.debezium.time.ZonedTimestamp;
import java.time.ZonedDateTime;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class ZonedTimestampType
extends AbstractTimestampType {
    public static final ZonedTimestampType INSTANCE = new ZonedTimestampType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.ZonedTimestamp"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTimestampWithTimeZone((String)value);
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof String) {
            ZonedDateTime zdt = ZonedDateTime.parse((String)value, ZonedTimestamp.FORMATTER).withZoneSameInstant(this.getDatabaseTimeZone().toZoneId());
            query.setParameter(index, (Object)zdt, (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITH_TIMEZONE);
        } else {
            this.throwUnexpectedValue(value);
        }
    }

    @Override
    protected int getJdbcType() {
        return 2014;
    }
}

