/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.config.Field;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="UnitTests")
public class JdbcSinkConnectorConfigTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSinkConnectorConfigTest.class);

    @Test
    public void testMissingRequiredConfigurationPropertiesFail() {
        Field connectionUrl = JdbcSinkConnectorConfig.CONNECTION_URL_FIELD;
        Field connectionUserName = JdbcSinkConnectorConfig.CONNECTION_USER_FIELD;
        Field connectionPassword = JdbcSinkConnectorConfig.CONNECTION_PASSWORD_FIELD;
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Collections.emptyMap());
        Assertions.assertThat((boolean)config.validateAndRecord(List.of(connectionUrl, connectionUserName, connectionPassword), arg_0 -> ((Logger)LOGGER).error(arg_0))).isFalse();
    }

    @Test
    public void testNonDefaultInsertModeProperty() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("insert.mode", "upsert");
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(properties);
        Assertions.assertThat((boolean)config.validateAndRecord(List.of(JdbcSinkConnectorConfig.INSERT_MODE_FIELD), arg_0 -> ((Logger)LOGGER).error(arg_0))).isFalse();
        Assertions.assertThat((Object)config.getInsertMode()).isEqualTo((Object)JdbcSinkConnectorConfig.InsertMode.UPSERT);
    }

    @Test
    public void testNonDefaultDeleteEnabledPropertyWithPrimaryKeyModeNotRecordKey() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("delete.enabled", "true");
        properties.put("primary.key.mode", "record_value");
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(properties);
        Assertions.assertThat((boolean)config.validateAndRecord(List.of(JdbcSinkConnectorConfig.DELETE_ENABLED_FIELD, JdbcSinkConnectorConfig.PRIMARY_KEY_MODE_FIELD), arg_0 -> ((Logger)LOGGER).error(arg_0))).isFalse();
    }

    @Test
    public void testNonDefaultDeleteEnabledPropertyWithPrimaryKeyModeRecordKey() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("delete.enabled", "true");
        properties.put("primary.key.mode", "record_key");
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(properties);
        Assertions.assertThat((boolean)config.validateAndRecord(List.of(JdbcSinkConnectorConfig.DELETE_ENABLED_FIELD, JdbcSinkConnectorConfig.PRIMARY_KEY_MODE_FIELD), arg_0 -> ((Logger)LOGGER).error(arg_0))).isTrue();
        Assertions.assertThat((boolean)config.isDeleteEnabled()).isTrue();
    }

    @Test
    public void testNonDefaultTableNameFormatProperty() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("table.name.format", "e2e-${topic}");
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(properties);
        Assertions.assertThat((boolean)config.validateAndRecord(List.of(JdbcSinkConnectorConfig.TABLE_NAME_FORMAT_FIELD), arg_0 -> ((Logger)LOGGER).error(arg_0))).isTrue();
        Assertions.assertThat((String)config.getTableNameFormat()).isEqualTo((Object)"e2e-${topic}");
    }

    @Test
    public void testNonDefaultPrimaryKeyModeProperty() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("primary.key.mode", "record_value");
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(properties);
        Assertions.assertThat((boolean)config.validateAndRecord(List.of(JdbcSinkConnectorConfig.PRIMARY_KEY_MODE_FIELD), arg_0 -> ((Logger)LOGGER).error(arg_0))).isTrue();
        Assertions.assertThat((Object)config.getPrimaryKeyMode()).isEqualTo((Object)JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE);
    }

    @Test
    public void testNonDefaultPrimaryKeyFieldsProperty() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("primary.key.fields", "id,name");
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(properties);
        Assertions.assertThat((boolean)config.validateAndRecord(List.of(JdbcSinkConnectorConfig.PRIMARY_KEY_FIELDS_FIELD), arg_0 -> ((Logger)LOGGER).error(arg_0))).isTrue();
        Assertions.assertThat((Collection)config.getPrimaryKeyFields()).contains(new Object[]{"id", "name"});
    }
}

