/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect;

import io.debezium.DebeziumException;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.naming.ColumnNamingStrategy;
import io.debezium.connector.jdbc.naming.TableNamingStrategy;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import io.debezium.connector.jdbc.relational.TableId;
import io.debezium.connector.jdbc.type.Type;
import io.debezium.connector.jdbc.type.connect.AbstractConnectSchemaType;
import io.debezium.connector.jdbc.type.connect.ConnectBooleanType;
import io.debezium.connector.jdbc.type.connect.ConnectBytesType;
import io.debezium.connector.jdbc.type.connect.ConnectDateType;
import io.debezium.connector.jdbc.type.connect.ConnectDecimalType;
import io.debezium.connector.jdbc.type.connect.ConnectFloat32Type;
import io.debezium.connector.jdbc.type.connect.ConnectFloat64Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt16Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt32Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt64Type;
import io.debezium.connector.jdbc.type.connect.ConnectInt8Type;
import io.debezium.connector.jdbc.type.connect.ConnectMapToConnectStringType;
import io.debezium.connector.jdbc.type.connect.ConnectStringType;
import io.debezium.connector.jdbc.type.connect.ConnectTimeType;
import io.debezium.connector.jdbc.type.connect.ConnectTimestampType;
import io.debezium.connector.jdbc.type.debezium.DateType;
import io.debezium.connector.jdbc.type.debezium.MicroTimeType;
import io.debezium.connector.jdbc.type.debezium.MicroTimestampType;
import io.debezium.connector.jdbc.type.debezium.NanoTimeType;
import io.debezium.connector.jdbc.type.debezium.NanoTimestampType;
import io.debezium.connector.jdbc.type.debezium.TimeType;
import io.debezium.connector.jdbc.type.debezium.TimestampType;
import io.debezium.connector.jdbc.type.debezium.VariableScaleDecimalType;
import io.debezium.connector.jdbc.type.debezium.ZonedTimeType;
import io.debezium.connector.jdbc.type.debezium.ZonedTimestampType;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralDatabaseDialect
implements DatabaseDialect {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralDatabaseDialect.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private final JdbcSinkConnectorConfig connectorConfig;
    private final Dialect dialect;
    private final DdlTypeRegistry ddlTypeRegistry;
    private final IdentifierHelper identifierHelper;
    private final TableNamingStrategy tableNamingStrategy;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final Map<String, Type> typeRegistry = new HashMap<String, Type>();
    private final Map<String, String> typeCoercions = new HashMap<String, String>();
    private final boolean jdbcTimeZone;

    public GeneralDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        this.connectorConfig = config;
        this.dialect = GeneralDatabaseDialect.unwrapSessionFactory(sessionFactory).getJdbcServices().getDialect();
        this.ddlTypeRegistry = GeneralDatabaseDialect.unwrapSessionFactory(sessionFactory).getTypeConfiguration().getDdlTypeRegistry();
        this.identifierHelper = GeneralDatabaseDialect.unwrapSessionFactory(sessionFactory).getJdbcServices().getJdbcEnvironment().getIdentifierHelper();
        this.tableNamingStrategy = this.connectorConfig.getTableNamingStrategy();
        this.columnNamingStrategy = this.connectorConfig.getColumnNamingStrategy();
        String jdbcTimeZone = config.getHibernateConfiguration().getProperty("hibernate.jdbc.time_zone");
        this.jdbcTimeZone = !Strings.isNullOrEmpty((String)jdbcTimeZone);
        this.registerTypes();
        LOGGER.info("Database TimeZone: {}", (Object)this.getDatabaseTimeZone(sessionFactory));
    }

    @Override
    public TableId getTableIdFromTopic(SinkRecord record) {
        NameQualifierSupport nameQualifierSupport = this.dialect.getNameQualifierSupport();
        String tableName = this.tableNamingStrategy.resolveTableName(this.connectorConfig, record);
        String[] parts = io.debezium.relational.TableId.parseParts((String)tableName);
        if (parts.length == 3) {
            return new TableId(parts[0], parts[1], parts[2]);
        }
        if (parts.length == 2) {
            if (nameQualifierSupport != null && nameQualifierSupport.supportsCatalogs() && !nameQualifierSupport.supportsSchemas()) {
                return new TableId(parts[0], null, parts[1]);
            }
            return new TableId(null, parts[0], parts[1]);
        }
        if (parts.length == 1) {
            return new TableId(null, null, parts[0]);
        }
        throw new DebeziumException("Failed to parse table name into TableId: " + tableName);
    }

    @Override
    public boolean tableExists(Connection connection, TableId tableId) throws SQLException {
        if (this.isIdentifierUppercaseWhenNotQuoted() && !this.getConfig().isQuoteIdentifiers()) {
            tableId = tableId.toUpperCase();
        }
        DatabaseMetaData metadata = connection.getMetaData();
        try (ResultSet rs = metadata.getTables(tableId.getCatalogName(), tableId.getSchemaName(), tableId.getTableName(), null);){
            boolean bl = rs.next();
            return bl;
        }
    }

    @Override
    public TableDescriptor readTable(Connection connection, TableId tableId) throws SQLException {
        DatabaseMetaData metadata;
        TableDescriptor.Builder table;
        block23: {
            if (this.isIdentifierUppercaseWhenNotQuoted() && !this.getConfig().isQuoteIdentifiers()) {
                tableId = tableId.toUpperCase();
            }
            table = TableDescriptor.builder();
            metadata = connection.getMetaData();
            try (ResultSet rs = metadata.getTables(tableId.getCatalogName(), tableId.getSchemaName(), tableId.getTableName(), null);){
                if (rs.next()) {
                    table.catalogName(rs.getString(1));
                    table.schemaName(rs.getString(2));
                    table.tableName(tableId.getTableName());
                    String tableType = rs.getString(4);
                    table.type(Strings.isNullOrBlank((String)tableType) ? "TABLE" : tableType);
                    break block23;
                }
                throw new IllegalStateException("Failed to find table: " + tableId.toFullIdentiferString());
            }
        }
        ArrayList<String> primaryKeyColumNames = new ArrayList<String>();
        try (ResultSet rs = metadata.getPrimaryKeys(tableId.getCatalogName(), tableId.getSchemaName(), tableId.getTableName());){
            while (rs.next()) {
                String columnName = rs.getString(4);
                primaryKeyColumNames.add(columnName);
                table.keyColumn(columnName);
            }
        }
        rs = metadata.getColumns(tableId.getCatalogName(), tableId.getSchemaName(), tableId.getTableName(), null);
        try {
            int resultSizeColumnSize = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                String autoIncrementValue;
                String catalogName = rs.getString(1);
                String schemaName = rs.getString(2);
                String columnTableName = rs.getString(3);
                String columnName = rs.getString(4);
                int jdbcType = rs.getInt(5);
                String typeName = rs.getString(6);
                int precision = rs.getInt(7);
                int scale = rs.getInt(9);
                int nullable = rs.getInt(11);
                String autoIncrement = "no";
                if (resultSizeColumnSize >= 23 && !Strings.isNullOrBlank((String)(autoIncrementValue = rs.getString(23)))) {
                    autoIncrement = autoIncrementValue;
                }
                ColumnDescriptor column = ColumnDescriptor.builder().columnName(columnName).jdbcType(jdbcType).typeName(typeName).precision(precision).scale(scale).nullable(GeneralDatabaseDialect.isColumnNullable(columnName, primaryKeyColumNames, nullable)).autoIncrement("yes".equalsIgnoreCase(autoIncrement)).primarykey(primaryKeyColumNames.contains(columnName)).build();
                table.column(column);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return table.build();
    }

    @Override
    public Set<String> resolveMissingFields(SinkRecordDescriptor record, TableDescriptor table) {
        HashSet<String> missingFields = new HashSet<String>();
        for (SinkRecordDescriptor.FieldDescriptor field : record.getFields().values()) {
            String columnIdentifier;
            String columnName = this.columnNamingStrategy.resolveColumnName(field.getName());
            if (!(!this.isIdentifierUppercaseWhenNotQuoted() || this.getConfig().isQuoteIdentifiers() || (columnIdentifier = this.toIdentifier(columnName)).startsWith("\"") && columnIdentifier.endsWith("\""))) {
                columnName = columnName.toUpperCase();
            }
            if (table.hasColumn(columnName)) continue;
            missingFields.add(field.getName());
        }
        return missingFields;
    }

    @Override
    public String getCreateTableStatement(SinkRecordDescriptor record, TableId tableId) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("CREATE TABLE ");
        builder.append(this.getQualifiedTableName(tableId));
        builder.append(" (");
        builder.appendLists(", ", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> {
            SinkRecordDescriptor.FieldDescriptor field = record.getFields().get(name);
            String columnName = this.toIdentifier(this.columnNamingStrategy.resolveColumnName((String)name));
            String columnType = field.getTypeName();
            StringBuilder columnSpec = new StringBuilder();
            columnSpec.append(columnName).append(" ").append(columnType);
            this.addColumnDefaultValue(field, columnSpec);
            if (field.isKey()) {
                columnSpec.append(" NOT NULL");
            } else {
                columnSpec.append(field.getSchema().isOptional() ? " NULL" : " NOT NULL");
            }
            return columnSpec.toString();
        });
        if (!record.getKeyFieldNames().isEmpty()) {
            builder.append(", PRIMARY KEY(");
            builder.appendList(", ", record.getKeyFieldNames(), name -> {
                SinkRecordDescriptor.FieldDescriptor field = record.getFields().get(name);
                return this.toIdentifier(this.columnNamingStrategy.resolveColumnName(field.getName()));
            });
            builder.append(")");
        }
        builder.append(")");
        return builder.build();
    }

    @Override
    public String getAlterTableStatement(TableDescriptor table, SinkRecordDescriptor record, Set<String> missingFields) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("ALTER TABLE ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" ");
        builder.appendList(this.getAlterTableStatementFieldDelimiter(), missingFields, name -> {
            SinkRecordDescriptor.FieldDescriptor field = record.getFields().get(name);
            StringBuilder addColumnSpec = new StringBuilder();
            addColumnSpec.append("ADD ");
            addColumnSpec.append(this.toIdentifier(this.columnNamingStrategy.resolveColumnName((String)name)));
            addColumnSpec.append(" ").append(field.getTypeName());
            this.addColumnDefaultValue(field, addColumnSpec);
            addColumnSpec.append(field.getSchema().isOptional() ? " NULL" : " NOT NULL");
            return addColumnSpec.toString();
        });
        return builder.build();
    }

    @Override
    public String getInsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" (");
        builder.appendLists(", ", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(", ", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnQueryBindingFromField((String)name, table, record));
        builder.append(")");
        return builder.build();
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        throw new UnsupportedOperationException("Upsert configurations are not supported for this dialect");
    }

    @Override
    public String getUpdateStatement(TableDescriptor table, SinkRecordDescriptor record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("UPDATE ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" SET ");
        builder.appendList(", ", record.getNonKeyFieldNames(), name -> this.columnNameEqualsBinding((String)name, table, record));
        if (!record.getKeyFieldNames().isEmpty()) {
            builder.append(" WHERE ");
            builder.appendList(" AND ", record.getKeyFieldNames(), name -> this.columnNameEqualsBinding((String)name, table, record));
        }
        return builder.build();
    }

    @Override
    public String getDeleteStatement(TableDescriptor table, SinkRecordDescriptor record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getQualifiedTableName(table.getId()));
        if (!record.getKeyFieldNames().isEmpty()) {
            builder.append(" WHERE ");
            builder.appendList(" AND ", record.getKeyFieldNames(), name -> this.columnNameEqualsBinding((String)name, table, record));
        }
        return builder.build();
    }

    @Override
    public String getQueryBindingWithValueCast(ColumnDescriptor column, Schema schema, Type type) {
        return "?";
    }

    @Override
    public int bindValue(SinkRecordDescriptor.FieldDescriptor field, NativeQuery<?> query, int startIndex, Object value) {
        LOGGER.trace("Bind field '{}' at position {} with type {}: {}", new Object[]{field.getName(), startIndex, field.getType().getClass().getName(), value});
        field.bind(query, startIndex, value);
        return 1;
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return this.dialect.getMaxVarcharLength();
    }

    @Override
    public int getMaxNVarcharLengthInKey() {
        return this.getMaxVarcharLengthInKey();
    }

    @Override
    public int getMaxVarbinaryLength() {
        return this.dialect.getMaxVarbinaryLength();
    }

    @Override
    public boolean isTimeZoneSet() {
        return this.jdbcTimeZone;
    }

    @Override
    public boolean shouldBindTimeWithTimeZoneAsDatabaseTimeZone() {
        return false;
    }

    @Override
    public Type getSchemaType(Schema schema) {
        Type type;
        String columnType;
        Type type2;
        if (!Objects.isNull(schema.name()) && !Objects.isNull(type2 = this.typeRegistry.get(schema.name()))) {
            LOGGER.trace("Schema '{}' resolved by name from registry to type '{}'", (Object)schema.name(), (Object)type2);
            return type2;
        }
        if (!(Objects.isNull(schema.parameters()) || Objects.isNull(columnType = (String)schema.parameters().get("__debezium.source.column.type")) || Objects.isNull(type = this.typeRegistry.get(columnType)) || type instanceof AbstractConnectSchemaType)) {
            LOGGER.trace("Schema '{}' resolved by name from registry to type '{}' using parameter '{}'", new Object[]{schema, type, columnType});
            return type;
        }
        type2 = this.typeRegistry.get(schema.type().name());
        if (!Objects.isNull(type2)) {
            LOGGER.trace("Schema type '{}' resolved by name from registry to type '{}'", (Object)schema.type().name(), (Object)type2);
            return type2;
        }
        throw new ConnectException(String.format("Failed to resolve column type for schema: %s (%s)", schema.type(), schema.name()));
    }

    @Override
    public DatabaseVersion getVersion() {
        return this.dialect.getVersion();
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return this.dialect.getDefaultDecimalPrecision();
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return this.dialect.getDefaultTimestampPrecision();
    }

    @Override
    public boolean isNegativeScaleAllowed() {
        return false;
    }

    @Override
    public String getTypeName(int jdbcType) {
        return this.ddlTypeRegistry.getTypeName(jdbcType, this.dialect);
    }

    @Override
    public String getTypeName(int jdbcType, Size size) {
        return this.ddlTypeRegistry.getTypeName(jdbcType, size);
    }

    @Override
    public String getByteArrayFormat() {
        return "x'%s'";
    }

    @Override
    public String getFormattedBoolean(boolean value) {
        return value ? "1" : "0";
    }

    @Override
    public String getFormattedDate(TemporalAccessor value) {
        return String.format("'%s'", DATE_FORMATTER.format(value));
    }

    @Override
    public String getFormattedTime(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_TIME.format(value));
    }

    @Override
    public String getFormattedTimeWithTimeZone(String value) {
        return String.format("'%s'", value);
    }

    @Override
    public String getFormattedDateTime(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedDateTimeWithNanos(TemporalAccessor value) {
        return this.getFormattedDateTime(value);
    }

    @Override
    public String getFormattedTimestamp(TemporalAccessor value) {
        return String.format("'%s'", DateTimeFormatter.ISO_ZONED_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedTimestampWithTimeZone(String value) {
        return String.format("'%s'", value);
    }

    protected String getTypeName(int jdbcType, int length) {
        return this.getTypeName(jdbcType, Size.length((long)length));
    }

    protected String getDatabaseTimeZone(SessionFactory sessionFactory) {
        Optional<String> query = this.getDatabaseTimeZoneQuery();
        if (query.isPresent()) {
            String string;
            block9: {
                StatelessSession session = sessionFactory.openStatelessSession();
                try {
                    string = (String)session.doReturningWork(connection -> {
                        try (Statement st = connection.createStatement();
                             ResultSet rs = st.executeQuery((String)query.get());){
                            if (rs.next()) {
                                String string = this.getDatabaseTimeZoneQueryResult(rs);
                                return string;
                            }
                        }
                        return "N/A";
                    });
                    if (session == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                session.close();
            }
            return string;
        }
        return "N/A";
    }

    protected Optional<String> getDatabaseTimeZoneQuery() {
        return Optional.empty();
    }

    protected String getDatabaseTimeZoneQueryResult(ResultSet rs) throws SQLException {
        return rs.getString(1);
    }

    protected void registerTypes() {
        this.registerType(DateType.INSTANCE);
        this.registerType(TimeType.INSTANCE);
        this.registerType(MicroTimeType.INSTANCE);
        this.registerType(TimestampType.INSTANCE);
        this.registerType(MicroTimestampType.INSTANCE);
        this.registerType(NanoTimeType.INSTANCE);
        this.registerType(NanoTimestampType.INSTANCE);
        this.registerType(ZonedTimeType.INSTANCE);
        this.registerType(ZonedTimestampType.INSTANCE);
        this.registerType(VariableScaleDecimalType.INSTANCE);
        this.registerType(ConnectBooleanType.INSTANCE);
        this.registerType(ConnectBytesType.INSTANCE);
        this.registerType(ConnectDateType.INSTANCE);
        this.registerType(ConnectDecimalType.INSTANCE);
        this.registerType(ConnectFloat32Type.INSTANCE);
        this.registerType(ConnectFloat64Type.INSTANCE);
        this.registerType(ConnectInt8Type.INSTANCE);
        this.registerType(ConnectInt16Type.INSTANCE);
        this.registerType(ConnectInt32Type.INSTANCE);
        this.registerType(ConnectInt64Type.INSTANCE);
        this.registerType(ConnectStringType.INSTANCE);
        this.registerType(ConnectTimestampType.INSTANCE);
        this.registerType(ConnectTimeType.INSTANCE);
        this.registerType(ConnectMapToConnectStringType.INSTANCE);
    }

    protected void registerType(Type type) {
        type.configure(this.connectorConfig, this);
        for (String key : type.getRegistrationKeys()) {
            Type existing = this.typeRegistry.put(key, type);
            if (existing != null) {
                LOGGER.debug("Type replaced [{}]: {} -> {}", new Object[]{key, existing.getClass().getName(), type.getClass().getName()});
                continue;
            }
            LOGGER.debug("Type registered [{}]: {}", (Object)key, (Object)type.getClass().getName());
        }
    }

    protected ColumnNamingStrategy getColumnNamingStrategy() {
        return this.columnNamingStrategy;
    }

    protected JdbcSinkConnectorConfig getConfig() {
        return this.connectorConfig;
    }

    protected DatabaseVersion getDatabaseVersion() {
        return this.dialect.getVersion();
    }

    protected IdentifierHelper getIdentifierHelper() {
        return this.identifierHelper;
    }

    protected void addColumnDefaultValue(SinkRecordDescriptor.FieldDescriptor field, StringBuilder columnSpec) {
        String defaultValue;
        if (field.getSchema().defaultValue() != null && (defaultValue = field.getType().getDefaultValueBinding(this, field.getSchema(), field.getSchema().defaultValue())) != null) {
            columnSpec.append(" DEFAULT ").append(defaultValue);
        }
    }

    protected String columnQueryBindingFromField(String fieldName, TableDescriptor table, SinkRecordDescriptor record) {
        String columnName = this.columnNameFromField(fieldName, record);
        return record.getFields().get(fieldName).getQueryBinding(table.getColumnByName(columnName));
    }

    protected String columnNameFromField(String fieldName, SinkRecordDescriptor record) {
        SinkRecordDescriptor.FieldDescriptor field = record.getFields().get(fieldName);
        String columnName = this.getColumnNamingStrategy().resolveColumnName(field.getName());
        return this.getIdentifierHelper().toIdentifier(columnName, this.getConfig().isQuoteIdentifiers()).render(this.dialect);
    }

    protected String columnNameFromField(String fieldName, String prefix, SinkRecordDescriptor record) {
        return prefix + this.columnNameFromField(fieldName, record);
    }

    protected String toIdentifier(String text) {
        Identifier identifier = this.getIdentifierHelper().toIdentifier(text, this.getConfig().isQuoteIdentifiers());
        return identifier != null ? identifier.render(this.dialect) : text;
    }

    protected String toIdentifier(TableId tableId) {
        boolean quoted = this.getConfig().isQuoteIdentifiers();
        Identifier catalog = this.getIdentifierHelper().toIdentifier(tableId.getCatalogName(), quoted);
        Identifier schema = this.getIdentifierHelper().toIdentifier(tableId.getSchemaName(), quoted);
        Identifier table = this.getIdentifierHelper().toIdentifier(tableId.getTableName(), quoted);
        if (catalog != null && schema != null && table != null) {
            return String.format("%s.%s.%s", catalog.render(this.dialect), schema.render(this.dialect), table.render(this.dialect));
        }
        if (schema != null && table != null) {
            return String.format("%s.%s", schema.render(this.dialect), table.render(this.dialect));
        }
        if (table != null) {
            return table.render(this.dialect);
        }
        throw new IllegalStateException("Expected at least table identifier to be non-null");
    }

    protected boolean isIdentifierUppercaseWhenNotQuoted() {
        return false;
    }

    protected String getQualifiedTableName(TableId tableId) {
        if (!Strings.isNullOrBlank((String)tableId.getSchemaName())) {
            return this.toIdentifier(tableId.getSchemaName()) + "." + this.toIdentifier(tableId.getTableName());
        }
        return this.toIdentifier(tableId.getTableName());
    }

    private String columnNameEqualsBinding(String fieldName, TableDescriptor table, SinkRecordDescriptor record) {
        ColumnDescriptor column = table.getColumnByName(this.columnNameFromField(fieldName, record));
        SinkRecordDescriptor.FieldDescriptor field = record.getFields().get(fieldName);
        return this.toIdentifier(this.columnNamingStrategy.resolveColumnName(fieldName)) + "=" + field.getQueryBinding(column);
    }

    private static boolean isColumnNullable(String columnName, Collection<String> primaryKeyColumnNames, int nullability) {
        if (primaryKeyColumnNames.contains(columnName)) {
            return false;
        }
        return nullability != 0;
    }

    private static SessionFactoryImplementor unwrapSessionFactory(SessionFactory sessionFactory) {
        return (SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class);
    }
}

