/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.Values;

public class ValuesTableGroup
extends AbstractTableGroup {
    private final ValuesTableReference valuesTableReference;

    public ValuesTableGroup(NavigablePath navigablePath, TableGroupProducer tableGroupProducer, List<Values> valuesList, String sourceAlias, List<String> columnNames, boolean canUseInnerJoins, SessionFactoryImplementor sessionFactory) {
        super(canUseInnerJoins, navigablePath, tableGroupProducer, sourceAlias, null, sessionFactory);
        this.valuesTableReference = new ValuesTableReference(valuesList, sourceAlias, columnNames, sessionFactory);
    }

    @Override
    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference groupTableReference;
        if (((TableGroupProducer)this.getModelPart()).containsTableReference(tableExpression)) {
            return this.getPrimaryTableReference();
        }
        for (TableGroupJoin tableGroupJoin : this.getNestedTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        return null;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
    }

    @Override
    public ValuesTableReference getPrimaryTableReference() {
        return this.valuesTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }
}

