/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectDecimalType
extends AbstractType {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectDecimalType.class);
    public static final ConnectDecimalType INSTANCE = new ConnectDecimalType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Decimal"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision;
        int scale = Integer.parseInt(this.getSchemaParameter(schema, "scale").orElse("0"));
        if (scale < 0 && !dialect.isNegativeScaleAllowed()) {
            LOGGER.warn("Type {} detected with negative scale {}, using scale 0 instead.", (Object)schema.name(), (Object)scale);
            scale = 0;
        }
        if ((precision = Integer.parseInt(this.getSchemaParameter(schema, "connect.decimal.precision").orElse("0"))) > 0) {
            precision = Math.min(precision, dialect.getDefaultDecimalPrecision());
            return dialect.getTypeName(3, Size.precision((int)precision, (int)scale));
        }
        if (scale != 0) {
            return dialect.getTypeName(3, Size.precision((int)dialect.getDefaultDecimalPrecision(), (int)scale));
        }
        return dialect.getTypeName(3);
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        if (value instanceof Number) {
            return value.toString();
        }
        this.throwUnexpectedValue(value);
        return null;
    }
}

