/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import java.time.ZoneId;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemporalType
extends AbstractType {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTemporalType.class);
    private TimeZone databaseTimeZone;

    @Override
    public void configure(JdbcSinkConnectorConfig config, DatabaseDialect dialect) {
        super.configure(config, dialect);
        String databaseTimeZone = config.getDatabaseTimeZone();
        try {
            this.databaseTimeZone = TimeZone.getTimeZone(ZoneId.of(databaseTimeZone));
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve time zone '{}', please specify a correct time zone value", (Object)databaseTimeZone, (Object)e);
            throw e;
        }
    }

    protected TimeZone getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }
}

