/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration;

import com.mchange.v2.c3p0.DataSources;
import io.debezium.connector.jdbc.JdbcSinkConnector;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.JdbcSinkTaskTestContext;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.naming.DefaultTableNamingStrategy;
import io.debezium.connector.jdbc.naming.TableNamingStrategy;
import io.debezium.connector.jdbc.util.RandomTableNameGenerator;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.apache.kafka.connect.sink.SinkTaskContext;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcSinkTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJdbcSinkTest.class);
    private final Sink sink;
    private final RandomTableNameGenerator randomTableNameGenerator = new RandomTableNameGenerator();
    private final TableNamingStrategy tableNamingStrategy = new DefaultTableNamingStrategy();
    private JdbcSinkConnector sinkConnector;
    private SinkTask sinkTask;
    private DataSource dataSource;

    public AbstractJdbcSinkTest(Sink sink) {
        this.sink = sink;
    }

    @AfterEach
    public void afterEach() {
        this.stopSinkConnector();
        if (this.dataSource != null) {
            try {
                DataSources.destroy((DataSource)DataSources.pooledDataSource((DataSource)this.dataSource));
                LOGGER.info("Closed data source");
            }
            catch (SQLException e) {
                LOGGER.error("Failed to close data source", (Throwable)e);
            }
        }
    }

    protected Sink getSink() {
        return this.sink;
    }

    protected Map<String, String> getDefaultSinkConfig() {
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("connection.url", this.sink.getJdbcUrl());
        config.put("connection.username", this.sink.getUsername());
        config.put("connection.password", this.sink.getPassword());
        return config;
    }

    protected Map<String, String> getConfig(Map<String, String> properties) {
        Map<String, String> config = this.getDefaultSinkConfig();
        config.putAll(properties);
        return config;
    }

    protected DataSource dataSource() {
        try {
            if (this.dataSource == null) {
                LOGGER.info("Creating data source");
                Map<String, String> config = this.getDefaultSinkConfig();
                this.dataSource = DataSources.unpooledDataSource((String)config.get("connection.url"), (String)config.get("connection.username"), (String)config.get("connection.password"));
            }
            return this.dataSource;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create data source", e);
        }
    }

    protected void startSinkConnector(Map<String, String> properties) {
        this.sinkConnector = new JdbcSinkConnector();
        this.sinkConnector.start(properties);
        try {
            this.sinkTask = (SinkTask)this.sinkConnector.taskClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sinkTask.initialize((SinkTaskContext)new JdbcSinkTaskTestContext(properties));
            this.sinkTask.start(properties);
        }
        catch (Exception e) {
            this.sinkTask = null;
            this.sinkConnector = null;
            throw new RuntimeException(e);
        }
    }

    protected void stopSinkConnector() {
        if (this.sinkConnector != null) {
            if (this.sinkTask != null) {
                this.sinkTask.stop();
                this.sinkTask = null;
            }
            this.sinkConnector.stop();
            this.sinkConnector = null;
        }
    }

    protected void consume(SinkRecord record) {
        this.consume(Collections.singletonList(record));
    }

    protected void consume(List<SinkRecord> records) {
        this.sinkTask.put(records);
    }

    protected String randomTableName() {
        return this.randomTableNameGenerator.randomName();
    }

    protected String destinationTableName(SinkRecord record) {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(this.getDefaultSinkConfig());
        return this.sink.formatTableName(this.tableNamingStrategy.resolveTableName(config, record));
    }

    protected String topicName(String prefix, String schemaName, String tableName) {
        return prefix + "." + schemaName + "." + tableName;
    }

    protected void assertSinkConnectorIsRunning() {
        ((ObjectAssert)Assertions.assertThat((Object)this.sinkConnector).as("Sink connector is not currently running")).isNotNull();
    }
}

