/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect;

import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import io.debezium.connector.jdbc.relational.TableId;
import io.debezium.connector.jdbc.type.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.query.NativeQuery;

public interface DatabaseDialect {
    public DatabaseVersion getVersion();

    public TableId getTableIdFromTopic(SinkRecord var1);

    public boolean tableExists(Connection var1, TableId var2) throws SQLException;

    public TableDescriptor readTable(Connection var1, TableId var2) throws SQLException;

    public Set<String> resolveMissingFields(SinkRecordDescriptor var1, TableDescriptor var2);

    public String getCreateTableStatement(SinkRecordDescriptor var1, TableId var2);

    public String getAlterTableStatement(TableDescriptor var1, SinkRecordDescriptor var2, Set<String> var3);

    default public String getAlterTableStatementFieldDelimiter() {
        return " ";
    }

    public String getInsertStatement(TableDescriptor var1, SinkRecordDescriptor var2);

    public String getUpsertStatement(TableDescriptor var1, SinkRecordDescriptor var2);

    public String getUpdateStatement(TableDescriptor var1, SinkRecordDescriptor var2);

    public String getDeleteStatement(TableDescriptor var1, SinkRecordDescriptor var2);

    public int getMaxVarcharLengthInKey();

    public int getMaxNVarcharLengthInKey();

    public int getMaxVarbinaryLength();

    public boolean isTimeZoneSet();

    public boolean shouldBindTimeWithTimeZoneAsDatabaseTimeZone();

    default public int getMaxTimePrecision() {
        return 6;
    }

    default public int getMaxTimestampPrecision() {
        return 6;
    }

    public int getDefaultDecimalPrecision();

    public int getDefaultTimestampPrecision();

    public boolean isNegativeScaleAllowed();

    default public String getTimeQueryBinding() {
        return "?";
    }

    public String getByteArrayFormat();

    public String getFormattedBoolean(boolean var1);

    public String getFormattedDate(TemporalAccessor var1);

    public String getFormattedTime(TemporalAccessor var1);

    public String getFormattedTimeWithTimeZone(String var1);

    public String getFormattedDateTime(TemporalAccessor var1);

    public String getFormattedDateTimeWithNanos(TemporalAccessor var1);

    public String getFormattedTimestamp(TemporalAccessor var1);

    public String getFormattedTimestampWithTimeZone(String var1);

    public Type getSchemaType(Schema var1);

    public String getTypeName(int var1);

    public String getTypeName(int var1, Size var2);

    public int bindValue(SinkRecordDescriptor.FieldDescriptor var1, NativeQuery<?> var2, int var3, Object var4);
}

