/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class MicroTimeType
extends AbstractTimeType {
    public static final MicroTimeType INSTANCE = new MicroTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.MicroTime"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTime(this.toZonedDateTime((Long)value));
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Long) {
            query.setParameter(index, (Object)this.toZonedDateTime((Long)value), (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITHOUT_TIMEZONE);
        } else {
            this.throwUnexpectedValue(value);
        }
    }

    private ZonedDateTime toZonedDateTime(long value) {
        Duration duration = Duration.of(value, ChronoUnit.MICROS);
        return Instant.EPOCH.plus(duration.toNanos(), ChronoUnit.NANOS).atZone(ZoneOffset.UTC);
    }
}

