/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

public class DateType
extends AbstractType {
    public static final DateType INSTANCE = new DateType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.Date"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        return dialect.getTypeName(91);
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedDate(DateType.getInstantFromEpochDays((Integer)value).atZone(ZoneOffset.UTC));
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Integer) {
            query.setParameter(index, (Object)Date.from(DateType.getInstantFromEpochDays((Integer)value)));
        } else {
            this.throwUnexpectedValue(value);
        }
    }

    private static Instant getInstantFromEpochDays(Integer value) {
        return Instant.ofEpochSecond(value.longValue() * 86400L);
    }
}

