/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.time.ZonedTime;
import java.time.LocalDate;
import java.time.OffsetTime;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.query.Query;

public class ZonedTimeType
extends AbstractTimeType {
    public static final ZonedTimeType INSTANCE = new ZonedTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.ZonedTime"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision = this.getTimePrecision(schema);
        if (precision > 0) {
            return dialect.getTypeName(2013, Size.precision((int)precision));
        }
        return dialect.getTypeName(2013, Size.precision((int)dialect.getMaxTimePrecision()));
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTimeWithTimeZone((String)value);
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof String) {
            OffsetTime offsetTime = OffsetTime.parse((String)value, ZonedTime.FORMATTER);
            query.setParameter(index, (Object)offsetTime.atDate(LocalDate.now()).toInstant());
        } else {
            this.throwUnexpectedValue(value);
        }
    }
}

