/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimestampType;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class TimestampType
extends AbstractTimestampType {
    public static final TimestampType INSTANCE = new TimestampType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.Timestamp"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision = this.getTimePrecision(schema);
        if (precision > 0 && precision <= dialect.getMaxTimestampPrecision()) {
            return dialect.getTypeName(93, Size.precision((int)precision));
        }
        return dialect.getTypeName(93);
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        ZonedDateTime zdt = Instant.ofEpochMilli((Long)value).atZone(ZoneOffset.UTC);
        return dialect.getFormattedDateTime(zdt);
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Long) {
            ZonedDateTime zdt = Instant.ofEpochMilli((Long)value).atZone(ZoneOffset.UTC);
            query.setParameter(index, (Object)zdt, (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITHOUT_TIMEZONE);
        } else {
            this.throwUnexpectedValue(value);
        }
    }
}

