/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class TimeType
extends AbstractTimeType {
    public static final TimeType INSTANCE = new TimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.Time"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTime(this.toZonedDateTime((Integer)value));
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Integer) {
            ZonedDateTime zdt = this.toZonedDateTime((Integer)value);
            query.setParameter(index, (Object)zdt, (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITHOUT_TIMEZONE);
        } else {
            this.throwUnexpectedValue(value);
        }
    }

    private ZonedDateTime toZonedDateTime(int value) {
        return Instant.EPOCH.plus((long)value, ChronoUnit.MILLIS).atZone(ZoneOffset.UTC);
    }
}

