/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class ConnectTimeType
extends AbstractTimeType {
    public static final ConnectTimeType INSTANCE = new ConnectTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Time"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTime(this.toZonedDateTime((Date)value));
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Date) {
            ZonedDateTime zdt = this.toZonedDateTime((Date)value);
            query.setParameter(index, (Object)zdt, (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITHOUT_TIMEZONE);
        } else {
            this.throwUnexpectedValue(value);
        }
    }

    private ZonedDateTime toZonedDateTime(Date value) {
        return value.toInstant().atZone(ZoneOffset.UTC);
    }
}

