/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.Type;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.query.Query;

public abstract class AbstractType
implements Type {
    private static final String QUERY_BINDING = "?";
    private static final String SCHEMA_PARAMETER_COLUMN_TYPE = "__debezium.source.column.type";
    private static final String SCHEMA_PARAMETER_COLUMN_SIZE = "__debezium.source.column.length";
    private static final String SCHEMA_PARAMETER_COLUMN_PRECISION = "__debezium.source.column.scale";

    @Override
    public String getQueryBinding(Schema schema) {
        return QUERY_BINDING;
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        switch (schema.type()) {
            case INT8: {
                return Byte.toString((Byte)value);
            }
            case INT16: {
                return Short.toString((Short)value);
            }
            case INT32: {
                return Integer.toString((Integer)value);
            }
            case INT64: {
                return Long.toString((Long)value);
            }
            case FLOAT32: {
                return Float.toString(((Float)value).floatValue());
            }
            case FLOAT64: {
                return Double.toString((Double)value);
            }
            case STRING: {
                return "'" + value + "'";
            }
            case BOOLEAN: {
                return dialect.getFormattedBoolean((Boolean)value);
            }
        }
        throw new IllegalArgumentException(String.format("No default value resolution for schema type %s with name %s and type %s", schema.type(), schema.name(), this.getClass().getName()));
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        query.setParameter(index, value);
    }

    protected Optional<String> getSourceColumnType(Schema schema) {
        return this.getSchemaParameter(schema, SCHEMA_PARAMETER_COLUMN_TYPE);
    }

    protected Optional<String> getSourceColumnSize(Schema schema) {
        return this.getSchemaParameter(schema, SCHEMA_PARAMETER_COLUMN_SIZE);
    }

    protected Optional<String> getSourceColumnPrecision(Schema schema) {
        return this.getSchemaParameter(schema, SCHEMA_PARAMETER_COLUMN_PRECISION);
    }

    protected Optional<String> getSchemaParameter(Schema schema, String parameterName) {
        if (!Objects.isNull(schema.parameters())) {
            return Optional.ofNullable((String)schema.parameters().get(parameterName));
        }
        return Optional.empty();
    }

    protected void throwUnexpectedValue(Object value) {
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value.toString(), value.getClass().getName()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

