/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter;

import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkType;
import io.debezium.connector.jdbc.junit.jupiter.e2e.SkipWhenSink;
import io.debezium.util.Strings;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.testcontainers.containers.JdbcDatabaseContainer;

public abstract class AbstractSinkDatabaseContextProvider
implements BeforeAllCallback,
AfterAllCallback,
ParameterResolver,
ExecutionCondition {
    private final SinkType sinkType;
    private final JdbcDatabaseContainer<?> container;
    private final Sink sink;

    public AbstractSinkDatabaseContextProvider(SinkType sinkType, JdbcDatabaseContainer<?> container) {
        this.sinkType = sinkType;
        this.container = container;
        this.sink = new Sink(sinkType, container);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.container.start();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.container.stop();
        this.sink.close();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == Sink.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.sink;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        SkipWhenSink skipWhenSink;
        if (context.getTestMethod().isPresent() && (skipWhenSink = context.getRequiredTestMethod().getAnnotation(SkipWhenSink.class)) != null) {
            for (SinkType skipType : skipWhenSink.value()) {
                if (skipType != this.sinkType) continue;
                if (Strings.isNullOrBlank((String)skipWhenSink.reason())) {
                    return ConditionEvaluationResult.disabled((String)("Annotated with SkipWhenSink for " + this.sinkType));
                }
                return ConditionEvaluationResult.disabled((String)("Skipped: " + skipWhenSink.reason()));
            }
        }
        return ConditionEvaluationResult.enabled((String)("Not annotated with SkipWhenSink for " + this.sinkType));
    }

    protected Sink getSink() {
        return this.sink;
    }
}

