/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.postgres.HstoreConverter;
import io.debezium.connector.jdbc.type.AbstractType;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.query.Query;

class JsonType
extends AbstractType {
    public static final JsonType INSTANCE = new JsonType();

    JsonType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.Json"};
    }

    @Override
    public String getQueryBinding(Schema schema) {
        if (this.isHstore(schema)) {
            return "cast(? as hstore)";
        }
        return String.format("cast(? as %s)", this.isJsonb(schema) ? "jsonb" : "json");
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        return this.resolveType(schema);
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (this.isHstore(schema)) {
            value = HstoreConverter.jsonToString((String)value);
        }
        super.bind(query, index, schema, value);
    }

    private String resolveType(Schema schema) {
        return this.isHstore(schema) ? "hstore" : (this.isJsonb(schema) ? "jsonb" : "json");
    }

    private boolean isJsonb(Schema schema) {
        return "JSONB".equals(this.getSourceColumnType(schema).orElse("JSON"));
    }

    private boolean isHstore(Schema schema) {
        return "HSTORE".equals(this.getSourceColumnType(schema).orElse("JSON"));
    }
}

