/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.testcontainers.containers.JdbcDatabaseContainer;

public abstract class JdbcConnectionProvider
implements AutoCloseable {
    private final JdbcDatabaseContainer<?> container;
    private final ConnectionInitializer initializer;
    private Connection connection;

    public JdbcConnectionProvider(JdbcDatabaseContainer<?> container, ConnectionInitializer initializer) {
        this.container = container;
        this.initializer = initializer;
    }

    public String getUsername() {
        return this.container.getUsername();
    }

    public String getPassword() {
        return this.container.getPassword();
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.connection = null;
    }

    public void execute(String statement) throws SQLException {
        Connection connection = this.getConnection();
        try (Statement st = connection.createStatement();){
            st.execute(statement);
        }
        catch (SQLException e) {
            throw new SQLException("Failed to execute SQL: " + statement, e);
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    protected JdbcDatabaseContainer<?> getContainer() {
        return this.container;
    }

    protected Connection getConnection() throws SQLException {
        if (!this.isInitialized()) {
            this.connection = this.container.createConnection("");
            if (this.initializer != null) {
                this.initializer.initialize(this.connection);
            }
        }
        return this.connection;
    }

    protected boolean isInitialized() {
        return this.connection != null;
    }

    @FunctionalInterface
    public static interface ConnectionInitializer {
        public void initialize(Connection var1) throws SQLException;
    }
}

