/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.GeneralDatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.dialect.postgres.BitType;
import io.debezium.connector.jdbc.dialect.postgres.CaseInsensitiveTextType;
import io.debezium.connector.jdbc.dialect.postgres.CidrType;
import io.debezium.connector.jdbc.dialect.postgres.EnumType;
import io.debezium.connector.jdbc.dialect.postgres.InetType;
import io.debezium.connector.jdbc.dialect.postgres.IntervalType;
import io.debezium.connector.jdbc.dialect.postgres.JsonType;
import io.debezium.connector.jdbc.dialect.postgres.LtreeType;
import io.debezium.connector.jdbc.dialect.postgres.MacAddressType;
import io.debezium.connector.jdbc.dialect.postgres.MapToHstoreType;
import io.debezium.connector.jdbc.dialect.postgres.MoneyType;
import io.debezium.connector.jdbc.dialect.postgres.OidType;
import io.debezium.connector.jdbc.dialect.postgres.PointType;
import io.debezium.connector.jdbc.dialect.postgres.RangeType;
import io.debezium.connector.jdbc.dialect.postgres.SerialType;
import io.debezium.connector.jdbc.dialect.postgres.TimeWithTimezoneType;
import io.debezium.connector.jdbc.dialect.postgres.UuidType;
import io.debezium.connector.jdbc.dialect.postgres.XmlType;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;

public class PostgresDatabaseDialect
extends GeneralDatabaseDialect {
    private PostgresDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        super(config, sessionFactory);
    }

    @Override
    public int getMaxTimestampPrecision() {
        return 6;
    }

    @Override
    public boolean tableExists(Connection connection, String tableName) throws SQLException {
        if (!this.getConfig().isQuoteIdentifiers()) {
            tableName = Strings.isNullOrBlank((String)tableName) ? tableName : tableName.toLowerCase();
        }
        return super.tableExists(connection, tableName);
    }

    @Override
    public TableDescriptor readTable(Connection connection, String tableName) throws SQLException {
        if (!this.getConfig().isQuoteIdentifiers()) {
            tableName = Strings.isNullOrBlank((String)tableName) ? tableName : tableName.toLowerCase();
        }
        return super.readTable(connection, tableName);
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.toIdentifier(table.getId()));
        builder.append(" (");
        builder.appendLists(",", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(",", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnQueryBindingFromField((String)name, record));
        builder.append(") ON CONFLICT (");
        builder.appendList(",", record.getKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        if (record.getNonKeyFieldNames().isEmpty()) {
            builder.append(") DO NOTHING");
        } else {
            builder.append(") DO UPDATE SET ");
            builder.appendList(",", record.getNonKeyFieldNames(), name -> {
                String columnNme = this.columnNameFromField((String)name, record);
                return columnNme + "=EXCLUDED." + columnNme;
            });
        }
        return builder.build();
    }

    @Override
    public String getByteArrayFormat() {
        return "'\\x%s'";
    }

    @Override
    public String getFormattedBoolean(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    @Override
    public String getFormattedDateTimeWithNanos(ZonedDateTime value) {
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedTime(ZonedDateTime value) {
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value));
    }

    @Override
    protected void registerTypes() {
        super.registerTypes();
        this.registerType(TimeWithTimezoneType.INSTANCE);
        this.registerType(IntervalType.INSTANCE);
        this.registerType(SerialType.INSTANCE);
        this.registerType(BitType.INSTANCE);
        this.registerType(JsonType.INSTANCE);
        this.registerType(UuidType.INSTANCE);
        this.registerType(EnumType.INSTANCE);
        this.registerType(PointType.INSTANCE);
        this.registerType(MoneyType.INSTANCE);
        this.registerType(XmlType.INSTANCE);
        this.registerType(LtreeType.INSTANCE);
        this.registerType(MapToHstoreType.INSTANCE);
        this.registerType(RangeType.INSTANCE);
        this.registerType(CidrType.INSTANCE);
        this.registerType(MacAddressType.INSTANCE);
        this.registerType(InetType.INSTANCE);
        this.registerType(CaseInsensitiveTextType.INSTANCE);
        this.registerType(OidType.INSTANCE);
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return Integer.MAX_VALUE;
    }

    public static class PostgresDatabaseDialectProvider
    implements DatabaseDialectProvider {
        @Override
        public boolean supports(Dialect dialect) {
            return dialect instanceof PostgreSQLDialect;
        }

        @Override
        public Class<?> name() {
            return PostgresDatabaseDialect.class;
        }

        @Override
        public DatabaseDialect instantiate(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
            return new PostgresDatabaseDialect(config, sessionFactory);
        }
    }
}

