/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.GeneralDatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.dialect.mysql.BitType;
import io.debezium.connector.jdbc.dialect.mysql.BooleanType;
import io.debezium.connector.jdbc.dialect.mysql.BytesType;
import io.debezium.connector.jdbc.dialect.mysql.EnumType;
import io.debezium.connector.jdbc.dialect.mysql.IntegerType;
import io.debezium.connector.jdbc.dialect.mysql.JsonType;
import io.debezium.connector.jdbc.dialect.mysql.MapToJsonType;
import io.debezium.connector.jdbc.dialect.mysql.MediumIntType;
import io.debezium.connector.jdbc.dialect.mysql.SetType;
import io.debezium.connector.jdbc.dialect.mysql.TinyIntType;
import io.debezium.connector.jdbc.dialect.mysql.YearType;
import io.debezium.connector.jdbc.dialect.mysql.ZonedTimestampWithoutTimezoneType;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Strings;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;

public class MySqlDatabaseDialect
extends GeneralDatabaseDialect {
    private static final List<String> NO_DEFAULT_VALUE_TYPES = Arrays.asList("tinytext", "mediumtext", "longtext", "text", "tinyblob", "mediumblob", "lonblob");
    private static final DateTimeFormatter ISO_LOCAL_DATE_TIME_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    private MySqlDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        super(config, sessionFactory);
    }

    @Override
    protected void registerTypes() {
        super.registerTypes();
        this.registerType(BooleanType.INSTANCE);
        this.registerType(BitType.INSTANCE);
        this.registerType(BytesType.INSTANCE);
        this.registerType(EnumType.INSTANCE);
        this.registerType(SetType.INSTANCE);
        this.registerType(MediumIntType.INSTANCE);
        this.registerType(IntegerType.INSTANCE);
        this.registerType(TinyIntType.INSTANCE);
        this.registerType(YearType.INSTANCE);
        this.registerType(JsonType.INSTANCE);
        this.registerType(ZonedTimestampWithoutTimezoneType.INSTANCE);
        this.registerType(MapToJsonType.INSTANCE);
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return 255;
    }

    @Override
    public String getFormattedTime(ZonedDateTime value) {
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value));
    }

    @Override
    public String getFormattedDateTime(ZonedDateTime value) {
        return String.format("'%s'", ISO_LOCAL_DATE_TIME_WITH_SPACE.format(value));
    }

    @Override
    public String getFormattedTimestamp(ZonedDateTime value) {
        return String.format("'%s'", ISO_LOCAL_DATE_TIME_WITH_SPACE.format(value));
    }

    @Override
    public String getFormattedTimestampWithTimeZone(String value) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(value, ZonedTimestamp.FORMATTER);
        return String.format("'%s'", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(zonedDateTime));
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        List<String> updateColumnNames;
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("INSERT INTO ");
        builder.append(table.getId().getTableName());
        builder.append(" (");
        builder.appendLists(", ", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(", ", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnQueryBindingFromField((String)name, record));
        builder.append(") ");
        List<String> list = updateColumnNames = record.getNonKeyFieldNames().isEmpty() ? record.getKeyFieldNames() : record.getNonKeyFieldNames();
        if (this.getDatabaseVersion().isSameOrAfter(8, 0, 20)) {
            builder.append("AS new ON DUPLICATE KEY UPDATE ");
            builder.appendList(",", updateColumnNames, name -> {
                String columnName = this.columnNameFromField((String)name, record);
                return columnName + "=new." + columnName;
            });
        } else {
            builder.append("ON DUPLICATE KEY UPDATE ");
            builder.appendList(",", updateColumnNames, name -> {
                String columnName = this.columnNameFromField((String)name, record);
                return columnName + "=VALUES(" + columnName + ")";
            });
        }
        return builder.build();
    }

    @Override
    protected void addColumnDefaultValue(SinkRecordDescriptor.FieldDescriptor field, StringBuilder columnSpec) {
        String fieldType = field.getTypeName();
        if (!Strings.isNullOrBlank((String)fieldType) && NO_DEFAULT_VALUE_TYPES.contains(fieldType.toLowerCase())) {
            return;
        }
        super.addColumnDefaultValue(field, columnSpec);
    }

    public static class MySqlDatabaseDialectProvider
    implements DatabaseDialectProvider {
        @Override
        public boolean supports(Dialect dialect) {
            return dialect instanceof MySQLDialect;
        }

        @Override
        public Class<?> name() {
            return MySqlDatabaseDialect.class;
        }

        @Override
        public DatabaseDialect instantiate(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
            return new MySqlDatabaseDialect(config, sessionFactory);
        }
    }
}

