/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class ColumnReference
implements Expression,
Assignable {
    private final String qualifier;
    private final String columnExpression;
    private final boolean isFormula;
    private final String readExpression;
    private final String writeExpression;
    private final JdbcMapping jdbcMapping;

    public ColumnReference(String qualifier, SelectableMapping selectableMapping, SessionFactoryImplementor sessionFactory) {
        this(qualifier, selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getCustomWriteExpression(), selectableMapping.getJdbcMapping(), sessionFactory);
    }

    public ColumnReference(String qualifier, SelectableMapping selectableMapping, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this(qualifier, selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getCustomWriteExpression(), jdbcMapping, sessionFactory);
    }

    public ColumnReference(String qualifier, String columnExpression, boolean isFormula, String customReadExpression, String customWriteExpression, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this.qualifier = StringHelper.nullIfEmpty(qualifier);
        if (isFormula) {
            assert (qualifier != null);
            this.columnExpression = StringHelper.replace(columnExpression, "$PlaceHolder$", qualifier);
        } else {
            this.columnExpression = columnExpression;
        }
        this.isFormula = isFormula;
        this.readExpression = customReadExpression;
        this.writeExpression = isFormula ? null : (customWriteExpression != null ? (this.qualifier == null ? StringHelper.replace(customWriteExpression, "$PlaceHolder$.", "") : StringHelper.replace(customWriteExpression, "$PlaceHolder$", qualifier)) : "?");
        this.jdbcMapping = jdbcMapping;
    }

    public ColumnReference(TableReference tableReference, SelectableMapping selectableMapping, SessionFactoryImplementor sessionFactory) {
        this(tableReference.getIdentificationVariable(), selectableMapping, sessionFactory);
    }

    public ColumnReference(TableReference tableReference, String mapping, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this(tableReference.getIdentificationVariable(), mapping, false, null, null, jdbcMapping, sessionFactory);
    }

    public ColumnReference(TableReference tableReference, String columnExpression, boolean isFormula, String customReadExpression, String customWriteExpression, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this(tableReference.getIdentificationVariable(), columnExpression, isFormula, customReadExpression, customWriteExpression, jdbcMapping, sessionFactory);
    }

    @Override
    public ColumnReference getColumnReference() {
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public boolean isColumnExpressionFormula() {
        return this.isFormula;
    }

    public String getExpressionText() {
        StringBuilder sb = new StringBuilder();
        this.appendReadExpression(new StringBuilderSqlAppender(sb));
        return sb.toString();
    }

    public void appendReadExpression(SqlAppender appender) {
        if (this.isFormula) {
            appender.append(this.columnExpression);
        } else if (this.readExpression != null) {
            if (this.qualifier == null) {
                appender.append(StringHelper.replace(this.readExpression, "$PlaceHolder$.", ""));
            } else {
                appender.append(StringHelper.replace(this.readExpression, "$PlaceHolder$", this.qualifier));
            }
        } else {
            if (this.qualifier != null) {
                appender.append(this.qualifier);
                appender.append('.');
            }
            appender.append(this.columnExpression);
        }
    }

    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JdbcMapping getExpressionType() {
        return this.jdbcMapping;
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        interpreter.visitColumnReference(this);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getClass().getSimpleName(), this.getExpressionText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnReference that = (ColumnReference)o;
        return this.isFormula == that.isFormula && Objects.equals(this.qualifier, that.qualifier) && Objects.equals(this.columnExpression, that.columnExpression) && Objects.equals(this.readExpression, that.readExpression);
    }

    public int hashCode() {
        int result = this.qualifier != null ? this.qualifier.hashCode() : 0;
        result = 31 * result + (this.columnExpression != null ? this.columnExpression.hashCode() : 0);
        result = 31 * result + (this.isFormula ? 1 : 0);
        result = 31 * result + (this.readExpression != null ? this.readExpression.hashCode() : 0);
        return result;
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this);
    }
}

