/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.sqlserver;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.GeneralDatabaseDialect;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.dialect.sqlserver.BitType;
import io.debezium.connector.jdbc.dialect.sqlserver.XmlType;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;

public class SqlServerDatabaseDialect
extends GeneralDatabaseDialect {
    private SqlServerDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        super(config, sessionFactory);
    }

    @Override
    protected void registerTypes() {
        super.registerTypes();
        this.registerType(BitType.INSTANCE);
        this.registerType(XmlType.INSTANCE);
    }

    @Override
    public int getMaxVarcharLengthInKey() {
        return 900;
    }

    @Override
    public int getMaxTimePrecision() {
        return 7;
    }

    @Override
    public int getMaxTimestampPrecision() {
        return 7;
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, SinkRecordDescriptor record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("MERGE INTO ");
        builder.append(table.getId().getTableName());
        builder.append(" WITH (HOLDLOCK) AS TARGET USING (SELECT ");
        builder.appendLists(", ", record.getKeyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnNameFromField((String)name, this.columnQueryBindingFromField((String)name, record) + " AS ", record));
        builder.append(") AS INCOMING ON (");
        builder.appendList(" AND ", record.getKeyFieldNames(), name -> {
            String columnName = this.columnNameFromField((String)name, record);
            return "TARGET." + columnName + "=INCOMING." + columnName;
        });
        builder.append(")");
        if (!record.getNonKeyFieldNames().isEmpty()) {
            builder.append(" WHEN MATCHED THEN UPDATE SET ");
            builder.appendList(",", record.getNonKeyFieldNames(), name -> {
                String columnName = this.columnNameFromField((String)name, record);
                return columnName + "=INCOMING." + columnName;
            });
        }
        builder.append(" WHEN NOT MATCHED THEN INSERT (");
        builder.appendLists(", ", record.getNonKeyFieldNames(), record.getKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(",", record.getNonKeyFieldNames(), record.getKeyFieldNames(), name -> this.columnNameFromField((String)name, "INCOMING.", record));
        builder.append(")");
        builder.append(";");
        return builder.build();
    }

    @Override
    public String getByteArrayFormat() {
        return "CONVERT(VARBINARY, '0x%s')";
    }

    public static class SqlServerDatabaseDialectProvider
    implements DatabaseDialectProvider {
        @Override
        public boolean supports(Dialect dialect) {
            return dialect instanceof SQLServerDialect;
        }

        @Override
        public Class<?> name() {
            return SqlServerDatabaseDialect.class;
        }

        @Override
        public DatabaseDialect instantiate(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
            return new SqlServerDatabaseDialect(config, sessionFactory);
        }
    }
}

