/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.StoredProcedureParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.boot.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinitionBuilder;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.annotations.QueryHintDefinition;
import org.hibernate.cfg.annotations.ResultsetMappingSecondPass;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());

    public static void bindQuery(NamedQuery queryAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        String queryName = queryAnn.name();
        String queryString = queryAnn.query();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", queryName, queryString);
        }
        QueryHintDefinition hints = new QueryHintDefinition(queryName, queryAnn.hints());
        NamedHqlQueryDefinitionImpl queryMapping = ((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(queryName).setHqlString(queryString).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBoolean("org.hibernate.readOnly"))).setLockOptions(hints.determineLockOptions(queryAnn))).setComment(hints.getString("org.hibernate.comment"))).build();
        if (isDefault) {
            context.getMetadataCollector().addDefaultQuery(queryMapping);
        } else {
            context.getMetadataCollector().addNamedQuery(queryMapping);
        }
    }

    public static void bindNativeQuery(jakarta.persistence.NamedNativeQuery queryAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        String registrationName = queryAnn.name();
        String queryString = queryAnn.query();
        QueryHintDefinition hints = new QueryHintDefinition(registrationName, queryAnn.hints());
        String resultSetMappingName = queryAnn.resultSetMapping();
        String resultSetMappingClassName = Void.TYPE.equals(queryAnn.resultClass()) ? null : queryAnn.resultClass().getName();
        NamedNativeQueryDefinitionBuilder builder = (NamedNativeQueryDefinitionBuilder)new NamedNativeQueryDefinitionBuilder(registrationName).setSqlString(queryString).setResultSetMappingName(resultSetMappingName).setResultSetMappingClassName(resultSetMappingClassName).setQuerySpaces(null).setCacheable(hints.getCacheability()).setCacheMode(hints.getCacheMode()).setCacheRegion(hints.getString("org.hibernate.cacheRegion")).setTimeout(hints.getTimeout()).setFetchSize(hints.getInteger("org.hibernate.fetchSize")).setFlushMode(hints.getFlushMode()).setReadOnly(hints.getBoolean("org.hibernate.readOnly")).setComment(hints.getString("org.hibernate.comment")).addHints(hints.getHintsMap());
        NamedNativeQueryDefinition queryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedNativeQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static void bindNativeQuery(NamedNativeQuery queryAnn, MetadataBuildingContext context) {
        if (queryAnn == null) {
            return;
        }
        String registrationName = queryAnn.name();
        if (BinderHelper.isEmptyAnnotationValue(registrationName)) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        String resultSetMappingName = queryAnn.resultSetMapping();
        String resultSetMappingClassName = Void.TYPE.equals(queryAnn.resultClass()) ? null : queryAnn.resultClass().getName();
        NamedNativeQueryDefinitionBuilder builder = new NamedNativeQueryDefinitionBuilder(registrationName).setSqlString(queryAnn.query()).setResultSetMappingName(resultSetMappingName).setResultSetMappingClassName(resultSetMappingClassName).setQuerySpaces(null).setCacheable(queryAnn.cacheable()).setCacheRegion(BinderHelper.getAnnotationValueStringOrNull(queryAnn.cacheRegion())).setCacheMode(QueryBinder.getCacheMode(queryAnn.cacheMode())).setTimeout(queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout())).setFetchSize(queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize())).setFlushMode(QueryBinder.getFlushMode(queryAnn.flushMode())).setReadOnly(queryAnn.readOnly()).setQuerySpaces(CollectionHelper.setOf(queryAnn.querySpaces())).setComment(BinderHelper.getAnnotationValueStringOrNull(queryAnn.comment()));
        if (queryAnn.callable()) {
            NamedProcedureCallDefinition definition = QueryBinder.createStoredProcedure(builder, context, () -> QueryBinder.illegalCallSyntax(queryAnn));
            context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            DeprecationLogger.DEPRECATION_LOGGER.warn("Marking named native queries as callable is no longer supported; use '@jakarta.persistence.NamedStoredProcedureQuery' instead. Ignoring.");
        } else {
            NamedNativeQueryDefinition queryDefinition = builder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
            }
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static NamedProcedureCallDefinition createStoredProcedure(NamedNativeQueryDefinitionBuilder builder, MetadataBuildingContext context, Supplier<RuntimeException> exceptionProducer) {
        ArrayList<StoredProcedureParameter> storedProcedureParameters = new ArrayList<StoredProcedureParameter>();
        ArrayList<QueryHint> queryHints = new ArrayList<QueryHint>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        String sqlString = builder.getSqlString().trim();
        if (!sqlString.startsWith("{") || !sqlString.endsWith("}")) {
            throw exceptionProducer.get();
        }
        String procedureName = QueryBinder.parseJdbcCall(sqlString, parameterNames, exceptionProducer);
        AnnotationDescriptor ann = new AnnotationDescriptor(NamedStoredProcedureQuery.class);
        ann.setValue("name", (Object)builder.getName());
        ann.setValue("procedureName", (Object)procedureName);
        for (String parameterName : parameterNames) {
            AnnotationDescriptor parameterDescriptor = new AnnotationDescriptor(StoredProcedureParameter.class);
            parameterDescriptor.setValue("name", (Object)parameterName);
            parameterDescriptor.setValue("mode", (Object)ParameterMode.IN);
            String typeName = builder.getParameterTypes().get(parameterName);
            if (typeName == null) {
                parameterDescriptor.setValue("type", Object.class);
            } else {
                BasicType registeredType = context.getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(typeName);
                parameterDescriptor.setValue("type", (Object)registeredType.getJavaType());
            }
            storedProcedureParameters.add((StoredProcedureParameter)AnnotationFactory.create((AnnotationDescriptor)parameterDescriptor));
        }
        ann.setValue("parameters", (Object)storedProcedureParameters.toArray(new StoredProcedureParameter[storedProcedureParameters.size()]));
        if (builder.getResultSetMappingName() != null) {
            ann.setValue("resultSetMappings", (Object)new String[]{builder.getResultSetMappingName()});
        } else {
            ann.setValue("resultSetMappings", (Object)new String[0]);
        }
        if (builder.getResultSetMappingClassName() != null) {
            ann.setValue("resultClasses", (Object)new Class[]{context.getBootstrapContext().getClassLoaderAccess().classForName(builder.getResultSetMappingClassName())});
        } else {
            ann.setValue("resultClasses", (Object)new Class[0]);
        }
        if (builder.getQuerySpaces() != null) {
            AnnotationDescriptor hintDescriptor = new AnnotationDescriptor(QueryHint.class);
            hintDescriptor.setValue("name", (Object)"org.hibernate.query.native.spaces");
            hintDescriptor.setValue("value", (Object)String.join((CharSequence)" ", builder.getQuerySpaces()));
            queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor));
        }
        AnnotationDescriptor hintDescriptor2 = new AnnotationDescriptor(QueryHint.class);
        hintDescriptor2.setValue("name", (Object)"org.hibernate.callableFunction");
        hintDescriptor2.setValue("value", (Object)"true");
        queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor2));
        ann.setValue("hints", (Object)queryHints.toArray(new QueryHint[queryHints.size()]));
        return new NamedProcedureCallDefinitionImpl((NamedStoredProcedureQuery)AnnotationFactory.create((AnnotationDescriptor)ann));
    }

    public static void bindQueries(jakarta.persistence.NamedQueries queriesAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, context, isDefault);
        }
    }

    public static void bindNativeQueries(jakarta.persistence.NamedNativeQueries queriesAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (jakarta.persistence.NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, context, isDefault);
        }
    }

    public static void bindNativeQueries(NamedNativeQueries queriesAnn, MetadataBuildingContext context) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, context);
        }
    }

    public static void bindQuery(org.hibernate.annotations.NamedQuery queryAnn, MetadataBuildingContext context) {
        if (queryAnn == null) {
            return;
        }
        String registrationName = queryAnn.name();
        if (BinderHelper.isEmptyAnnotationValue(registrationName)) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        NamedHqlQueryDefinition.Builder builder = (NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(registrationName).setHqlString(queryAnn.query()).setCacheable(queryAnn.cacheable())).setCacheRegion(BinderHelper.getAnnotationValueStringOrNull(queryAnn.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(queryAnn.cacheMode()))).setTimeout(queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()))).setFetchSize(queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()))).setFlushMode(QueryBinder.getFlushMode(queryAnn.flushMode()))).setReadOnly(queryAnn.readOnly())).setComment(BinderHelper.isEmptyAnnotationValue(queryAnn.comment()) ? null : queryAnn.comment());
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", hqlQueryDefinition.getRegistrationName(), hqlQueryDefinition.getHqlString());
        }
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        FlushMode flushMode;
        switch (flushModeType) {
            case ALWAYS: {
                flushMode = FlushMode.ALWAYS;
                break;
            }
            case AUTO: {
                flushMode = FlushMode.AUTO;
                break;
            }
            case COMMIT: {
                flushMode = FlushMode.COMMIT;
                break;
            }
            case MANUAL: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                flushMode = null;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown flushModeType: " + flushModeType);
            }
        }
        return flushMode;
    }

    private static CacheMode getCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + cacheModeType);
    }

    public static void bindQueries(NamedQueries queriesAnn, MetadataBuildingContext context) {
        if (queriesAnn == null) {
            return;
        }
        for (org.hibernate.annotations.NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, context);
        }
    }

    public static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation == null) {
            return;
        }
        String registrationName = annotation.name();
        if (BinderHelper.isEmptyAnnotationValue(registrationName)) {
            throw new AnnotationException("Class or package level '@NamedStoredProcedureQuery' annotation must specify a 'name'");
        }
        NamedProcedureCallDefinitionImpl def = new NamedProcedureCallDefinitionImpl(annotation);
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedProcedureCall(def);
        } else {
            context.getMetadataCollector().addNamedProcedureCallDefinition(def);
        }
        LOG.debugf("Bound named stored procedure query : %s => %s", def.getRegistrationName(), def.getProcedureName());
    }

    public static void bindSqlResultSetMappings(SqlResultSetMappings ann, MetadataBuildingContext context, boolean isDefault) {
        if (ann == null) {
            return;
        }
        for (SqlResultSetMapping rs : ann.value()) {
            context.getMetadataCollector().addSecondPass(new ResultsetMappingSecondPass(rs, context, true));
        }
    }

    public static void bindSqlResultSetMapping(SqlResultSetMapping ann, MetadataBuildingContext context, boolean isDefault) {
        context.getMetadataCollector().addSecondPass(new ResultsetMappingSecondPass(ann, context, isDefault));
    }

    public static String parseJdbcCall(String sqlString, final List<String> parameterNames, Supplier<RuntimeException> exceptionProducer) {
        String procedureName = null;
        int index = QueryBinder.skipWhitespace(sqlString, 1);
        if (sqlString.charAt(index) == '?') {
            ++index;
            if (sqlString.charAt(index = QueryBinder.skipWhitespace(sqlString, index)) != '=') {
                throw exceptionProducer.get();
            }
            ++index;
            index = QueryBinder.skipWhitespace(sqlString, index);
        }
        if (!sqlString.regionMatches(true, index, "call", 0, 4)) {
            throw exceptionProducer.get();
        }
        index += 4;
        int procedureStart = index = QueryBinder.skipWhitespace(sqlString, index);
        while (index < sqlString.length()) {
            char c = sqlString.charAt(index);
            if (c == '(' || Character.isWhitespace(c)) {
                procedureName = sqlString.substring(procedureStart, index);
                break;
            }
            ++index;
        }
        index = QueryBinder.skipWhitespace(sqlString, index);
        ParameterParser.parse(sqlString.substring(index, sqlString.length() - 1), new ParameterRecognizer(){

            @Override
            public void ordinalParameter(int sourcePosition) {
                parameterNames.add("");
            }

            @Override
            public void namedParameter(String name, int sourcePosition) {
                parameterNames.add(name);
            }

            @Override
            public void jpaPositionalParameter(int label, int sourcePosition) {
                parameterNames.add("");
            }

            @Override
            public void other(char character) {
            }
        });
        return procedureName;
    }

    private static int skipWhitespace(String sqlString, int i) {
        while (i < sqlString.length() && Character.isWhitespace(sqlString.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static AnnotationException illegalCallSyntax(NamedNativeQuery queryAnn) {
        return new AnnotationException("Callable 'NamedNativeQuery' named '" + queryAnn.name() + "' does not use the JDBC call syntax");
    }
}

