/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SetType
extends AbstractType {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetType.class);
    public static final SetType INSTANCE = new SetType();

    SetType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.EnumSet"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        Optional<String> allowedValues = this.getSchemaParameter(schema, "allowed");
        if (allowedValues.isPresent()) {
            String[] values = allowedValues.get().split(",");
            return "set(" + Arrays.stream(values).map(v -> "'" + v + "'").collect(Collectors.joining(",")) + ")";
        }
        LOGGER.warn("SET was detected without any allowed values.");
        return "set()";
    }
}

