/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;

public class ConnectTimestampType
extends AbstractType {
    public static final ConnectTimestampType INSTANCE = new ConnectTimestampType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Timestamp"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision = this.getTimePrecision(schema);
        if (precision > 0 && precision <= dialect.getMaxTimestampPrecision()) {
            return dialect.getTypeName(93, Size.precision((int)precision));
        }
        return dialect.getTypeName(93);
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        ZonedDateTime zdt = ((Date)value).toInstant().atZone(ZoneOffset.UTC);
        return dialect.getFormattedTimestamp(zdt);
    }

    @Override
    public void bind(Query<?> query, int index, Schema schema, Object value) {
        if (value == null) {
            query.setParameter(index, null);
        } else if (value instanceof Date) {
            ZonedDateTime zdt = ((Date)value).toInstant().atZone(ZoneOffset.UTC);
            query.setParameter(index, (Object)zdt, (BindableType)StandardBasicTypes.ZONED_DATE_TIME_WITHOUT_TIMEZONE);
        } else {
            this.throwUnexpectedValue(value);
        }
    }

    protected int getTimePrecision(Schema schema) {
        String length = this.getSourceColumnSize(schema).orElse("0");
        Optional<String> scale = this.getSourceColumnPrecision(schema);
        return scale.map(Integer::parseInt).orElseGet(() -> Integer.parseInt(length));
    }
}

