/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix.util;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.storage.file.history.FileSchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    public static final String TEST_DATABASE = "testdb";
    public static final String TEST_CONNECTOR = "informix_server";
    public static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history.txt").toAbsolutePath();
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    private static final String STATEMENTS_TABLE_PLACEHOLDER = "#";
    private static final String STATEMENTS_SCHEMA_PLACEHOLDER = "@";
    public static final String IS_CDC_ENABLED = "select name, is_logging, is_buff_log, is_ansi from sysmaster:sysdatabases where name='%s'";

    public static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, TEST_DATABASE)).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 9088)).withDefault(JdbcConfiguration.USER, "informix")).withDefault(JdbcConfiguration.PASSWORD, "in4mix")).build();
    }

    public static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, TEST_DATABASE)).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 9088)).withDefault(JdbcConfiguration.USER, "informix")).withDefault(JdbcConfiguration.PASSWORD, "in4mix")).build();
    }

    public static Configuration.Builder defaultConfig() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.copy((Configuration)TestHelper.defaultJdbcConfig().map(key -> "database." + key)).with(CommonConnectorConfig.TOPIC_PREFIX, TEST_DATABASE)).with(RelationalDatabaseConnectorConfig.SNAPSHOT_LOCK_TIMEOUT_MS, TimeUnit.SECONDS.toMillis(30L))).with(InformixConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(InformixConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(InformixConnectorConfig.CDC_TIMEOUT, 1)).with(InformixConnectorConfig.CDC_BUFFERSIZE, 512);
    }

    public static InformixConnection adminConnection() {
        return new InformixConnection(TestHelper.adminJdbcConfig());
    }

    public static InformixConnection testConnection() {
        return LazyConnectionHolder.INSTANCE;
    }

    public static void assertCdcEnabled(InformixConnection conn) throws SQLException {
        Statement stmt = conn.connection().createStatement();
        ResultSet rs = stmt.executeQuery(String.format(IS_CDC_ENABLED, TEST_DATABASE));
        int is_logging = 0;
        int is_buff_logging = 0;
        while (rs.next()) {
            is_logging += rs.getInt("is_logging");
            is_buff_logging += rs.getInt("is_buff_log");
        }
        Assertions.assertThat((int)(is_logging + is_buff_logging)).isPositive();
    }

    private static class LazyConnectionHolder {
        static final InformixConnection INSTANCE = new InformixConnection(TestHelper.defaultJdbcConfig());

        private LazyConnectionHolder() {
        }
    }
}

