/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.data.SourceRecordAssert;
import io.debezium.embedded.async.AbstractAsyncEngineConnectorTest;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.time.Date;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class InformixCdcTypesIT
extends AbstractAsyncEngineConnectorTest {
    private InformixConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"drop table if exists test_bigint", "drop table if exists test_bigserial", "drop table if exists test_char", "drop table if exists test_date", "drop table if exists test_decimal", "drop table if exists test_decimal_20", "drop table if exists test_decimal_20_5", "create table test_bigint(a bigint)", "create table test_bigserial(a bigserial)", "create table test_char(a char)", "create table test_date(a date)", "create table test_decimal(a decimal)", "create table test_decimal_20(a decimal(20))", "create table test_decimal_20_5(a decimal(20, 5))"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        InformixCdcTypesIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{"drop table test_bigint", "drop table test_bigserial", "drop table test_char", "drop table test_date", "drop table test_decimal", "drop table test_decimal_20", "drop table test_decimal_20_5"}).close();
        }
    }

    @Test
    public void testTypes() throws Exception {
        String[] arrTestDate;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.NO_DATA)).with(RelationalDatabaseConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixCdcTypesIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        Long testLongValue = new Random().nextLong();
        this.insertOneAndValidate("test_bigint", Schema.OPTIONAL_INT64_SCHEMA, testLongValue.toString(), testLongValue);
        Long testBigSerialValue = new Random().nextLong();
        this.insertOneAndValidate("test_bigserial", Schema.INT64_SCHEMA, testBigSerialValue.toString(), testBigSerialValue);
        for (String strTestDate : arrTestDate = new String[]{"2022-01-01"}) {
            Integer d = Math.toIntExact(this.diffInDays("1970-01-01", strTestDate));
            this.insertOneAndValidate("test_date", Date.builder().optional().build(), "'" + strTestDate + "'", d);
        }
        LinkedHashMap<String, String> decimal_data_expect = new LinkedHashMap<String, String>(){
            {
                this.put("12.1", "12.1");
                this.put("22.12345678901234567890", "22.12345678901235");
                this.put("12345678901234567890.12345", "12345678901234570000");
            }
        };
        for (Map.Entry entry : decimal_data_expect.entrySet()) {
            this.insertOneAndValidate("test_decimal", Schema.OPTIONAL_STRING_SCHEMA, (String)entry.getKey(), entry.getValue());
        }
        LinkedHashMap<String, String> decimal_20_data_expect = new LinkedHashMap<String, String>(){
            {
                this.put("88.07", "88.07");
                this.put("33.12345", "33.12345");
                this.put("123456789012345.12345", "123456789012345.12345");
            }
        };
        for (Map.Entry entry : decimal_20_data_expect.entrySet()) {
            this.insertOneAndValidate("test_decimal_20", Schema.OPTIONAL_STRING_SCHEMA, (String)entry.getKey(), entry.getValue());
        }
        LinkedHashMap<String, String> decimal_20_5_data_expect = new LinkedHashMap<String, String>(){
            {
                this.put("12.1", "12.10000");
                this.put("22.12345", "22.12345");
                this.put("123456789012345.12345", "123456789012345.12345");
            }
        };
        for (Map.Entry entry : decimal_20_5_data_expect.entrySet()) {
            this.insertOneAndValidate("test_decimal_20_5", Schema.OPTIONAL_STRING_SCHEMA, (String)entry.getKey(), entry.getValue());
        }
    }

    private void insertOneAndValidate(String tableName, Schema valueSchema, String insertValue, Object expectValue) throws Exception {
        String topicName = String.format("testdb.informix.%s", tableName);
        this.connection.execute(new String[]{String.format("insert into %s values(%s)", tableName, insertValue)});
        this.waitForAvailableRecords();
        List records = this.consumeRecordsByTopic(1).recordsForTopic(topicName);
        ((ListAssert)Assertions.assertThat((List)records).isNotNull()).hasSize(1);
        Schema aSchema = SchemaBuilder.struct().optional().name(String.format("%s.Value", topicName)).field("a", valueSchema).build();
        Struct aStruct = new Struct(aSchema).put("a", expectValue);
        SourceRecordAssert.assertThat((SourceRecord)((SourceRecord)records.get(0))).valueAfterFieldIsEqualTo(aStruct);
    }

    private long diffInDays(String one, String other) {
        return LocalDate.parse(one).until(LocalDate.parse(other), ChronoUnit.DAYS);
    }
}

