/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotTest;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class IncrementalSnapshotIT
extends AbstractIncrementalSnapshotTest<InformixConnector> {
    private InformixConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS a", "DROP TABLE IF EXISTS b", "DROP TABLE IF EXISTS c", "DROP TABLE IF EXISTS debezium_signal", "CREATE TABLE a (pk int not null, aa int, primary key (pk))", "CREATE TABLE b (pk int not null, aa int, primary key (pk))", "CREATE TABLE c (pk1 int, pk2 int, pk3 int, pk4 int, aa int)", "CREATE TABLE debezium_signal (id varchar(64), type varchar(32), data varchar(255))"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.disable();
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        IncrementalSnapshotIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{"DROP TABLE a", "DROP TABLE b", "DROP TABLE c", "DROP TABLE debezium_signal"}).close();
        }
    }

    protected Class<InformixConnector> connectorClass() {
        return InformixConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected String topicName() {
        return "testdb.informix.a";
    }

    protected List<String> topicNames() {
        return List.of(this.topicName(), "testdb.informix.b");
    }

    protected String noPKTopicName() {
        return "testdb.informix.c";
    }

    protected String tableDataCollectionId() {
        return "testdb." + this.tableName();
    }

    protected List<String> tableDataCollectionIds() {
        return this.tableNames().stream().map(name -> "testdb." + name).collect(Collectors.toList());
    }

    protected String tableIncludeList() {
        return String.join((CharSequence)",", this.tableDataCollectionIds());
    }

    protected String tableName() {
        return "informix.a";
    }

    protected List<String> tableNames() {
        return List.of(this.tableName(), "informix.b");
    }

    protected String noPKTableName() {
        return "informix.c";
    }

    protected String noPKTableDataCollectionId() {
        return "testdb." + this.noPKTableName();
    }

    protected String signalTableName() {
        return "informix.debezium_signal";
    }

    protected String signalTableNameSanitized() {
        return "testdb." + this.signalTableName();
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.NO_DATA)).with(InformixConnectorConfig.SIGNAL_DATA_COLLECTION, this::signalTableNameSanitized)).with(InformixConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 250)).with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, this.noPKTableDataCollectionId() + ":pk1,pk2,pk3,pk4");
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        Configuration.Builder config = (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.config().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, storeOnlyCapturedDdl)).with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, this.noPKTableDataCollectionId() + ":pk1,pk2,pk3,pk4");
        return signalTableOnly ? (Configuration.Builder)config.with(InformixConnectorConfig.TABLE_EXCLUDE_LIST, this::tableDataCollectionId) : (Configuration.Builder)config.with(InformixConnectorConfig.TABLE_INCLUDE_LIST, this::tableIncludeList);
    }

    protected String connector() {
        return "informix_server";
    }

    protected String server() {
        return "testdb";
    }

    @Test
    @Ignore(value="Informix does not support DDL operations on tables defined for replication")
    public void snapshotPreceededBySchemaChange() throws Exception {
        super.snapshotPreceededBySchemaChange();
    }
}

