/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.AbstractPartition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InformixPartition
extends AbstractPartition
implements Partition {
    private static final String PARTITION_KEY = "databaseName";

    public InformixPartition(String databaseName) {
        super(databaseName);
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)PARTITION_KEY, (Object)this.databaseName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InformixPartition other = (InformixPartition)((Object)obj);
        return Objects.equals(this.databaseName, other.databaseName);
    }

    public int hashCode() {
        return this.databaseName.hashCode();
    }

    public String toString() {
        return "InformixPartition [sourcePartition=" + String.valueOf(this.getSourcePartition()) + "]";
    }

    static class Provider
    implements Partition.Provider<InformixPartition> {
        private final InformixConnectorConfig connectorConfig;

        Provider(InformixConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<InformixPartition> getPartitions() {
            return Collections.singleton(new InformixPartition(this.connectorConfig.getLogicalName()));
        }
    }
}

