/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

public class InformixEventMetadataProvider
implements EventMetadataProvider {
    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null || source == null) {
            return null;
        }
        Long timestamp = value.getStruct("source").getInt64("ts_ms");
        return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
    }

    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null || source == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        return Collect.hashMapOf((Object)"commit_lsn", (Object)sourceInfo.getString("commit_lsn"), (Object)"change_lsn", (Object)sourceInfo.getString("change_lsn"), (Object)"begin_lsn", (Object)sourceInfo.getString("begin_lsn"));
    }

    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        return value == null || source == null ? null : value.getStruct("source").getString("txId");
    }
}

