/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixSourceInfoStructMaker;
import io.debezium.connector.informix.Lsn;
import io.debezium.connector.informix.Module;
import io.debezium.document.Document;
import io.debezium.heartbeat.DatabaseHeartbeatImpl;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;

public class InformixConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    protected static final String CDC_DATABASE = "syscdcv1";
    protected static final int DEFAULT_PORT = 9088;
    protected static final int DEFAULT_CDC_BUFFERSIZE = 65536;
    protected static final int DEFAULT_CDC_TIMEOUT = 5;
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(9088);
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create((String)"snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, (Enum)SnapshotIsolationMode.REPEATABLE_READ).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is '" + SnapshotIsolationMode.REPEATABLE_READ.getValue() + "', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of '" + SnapshotIsolationMode.EXCLUSIVE.getValue() + "' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. In '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' mode no table locks or any *long-lasting* row-level locks are acquired, but connector does not guarantee snapshot consistency.In '" + SnapshotIsolationMode.READ_UNCOMMITTED.getValue() + "' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.");
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create((String)"snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, (Enum)SnapshotLockingMode.EXCLUSIVE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)2)).withDescription("Controls how the connector holds locks on tables while performing the schema snapshot when `snapshot.isolation.mode` is `REPEATABLE_READ` or `EXCLUSIVE`. The 'exclusive' which means the connector will hold a table lock for exclusive table access for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this is done using a flashback query that requires no locks. However, in some cases it may be desirable to avoid locks entirely which can be done by specifying 'none'. This mode is only safe to use if no schema changes are happening while the snapshot is taken.");
    public static final Field CDC_BUFFERSIZE = Field.create((String)"cdc.buffersize").withDisplayName("CDC Engine buffer size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Size of the read buffer for receiving events from the server, in bytes.").withValidation(new Field.Validator[]{Field::isNonNegativeInteger}).withDefault(65536);
    public static final Field CDC_TIMEOUT = Field.create((String)"cdc.timeout").withDisplayName("CDC Engine timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specifies a timeout to interrupt blocking to wait on an event, in seconds. The timeout allows the CDC API to periodically break to receive a timeout event. This in turns allows the CDC engine to close cleanly as well as indicate to the running program the connection is alive and active.").withValidation(new Field.Validator[]{Field::isNonNegativeInteger}).withDefault(5);
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(InformixSourceInfoStructMaker.class.getName());
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Informix").type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, QUERY_TIMEOUT_MS, DATABASE_NAME}).connector(new Field[]{SNAPSHOT_MODE, SNAPSHOT_ISOLATION_MODE, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, CDC_BUFFERSIZE, CDC_TIMEOUT}).events(new Field[]{SOURCE_INFO_STRUCT_MAKER}).excluding(new Field[]{SCHEMA_INCLUDE_LIST, SCHEMA_EXCLUDE_LIST, INCLUDE_SCHEMA_COMMENTS, INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES, SNAPSHOT_MAX_THREADS, DatabaseHeartbeatImpl.HEARTBEAT_ACTION_QUERY}).create();
    public static final Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final String databaseName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;
    private final JdbcConfiguration cdcJdbcConfig;
    private final int cdcBuffersize;
    private final int cdcTimeout;
    private final SnapshotLockingMode snapshotLockingMode;

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public InformixConnectorConfig(Configuration config) {
        super(InformixConnector.class, config, (Tables.TableFilter)new SystemTablesPredicate(), t -> t.catalog() + "." + t.schema() + "." + t.table(), false, ColumnFilterMode.SCHEMA, false);
        this.databaseName = config.getString(DATABASE_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE), SNAPSHOT_ISOLATION_MODE.defaultValueAsString());
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE), SNAPSHOT_LOCKING_MODE.defaultValueAsString());
        this.cdcJdbcConfig = JdbcConfiguration.adapt((Configuration)((Configuration.Builder)this.getJdbcConfig().edit().with(JdbcConfiguration.DATABASE, CDC_DATABASE)).build());
        this.cdcBuffersize = config.getInteger(CDC_BUFFERSIZE);
        this.cdcTimeout = config.getInteger(CDC_TIMEOUT);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public Optional<? extends EnumeratedValue> getSnapshotLockingMode() {
        return Optional.of(this.snapshotLockingMode);
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public JdbcConfiguration getCdcJdbcConfig() {
        return this.cdcJdbcConfig;
    }

    public int getCdcBuffersize() {
        return this.cdcBuffersize;
    }

    public int getCdcTimeout() {
        return this.cdcTimeout;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return Lsn.of(recorded.getString((CharSequence)"change_lsn")).compareTo(Lsn.of(desired.getString((CharSequence)"change_lsn"))) < 1;
            }
        };
    }

    public String getContextName() {
        return Module.contextName();
    }

    public boolean isSignalDataCollection(DataCollectionId dataCollectionId) {
        String signalingDataCollection = this.getSignalingDataCollectionId();
        return signalingDataCollection != null && !signalingDataCollection.isEmpty() && dataCollectionId.identifier().endsWith(signalingDataCollection);
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return !t.table().toLowerCase().startsWith("sys");
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always"),
        INITIAL("initial"),
        INITIAL_ONLY("initial_only"),
        SCHEMA_ONLY("schema_only"),
        NO_DATA("no_data"),
        RECOVERY("recovery"),
        WHEN_NEEDED("when_needed"),
        CONFIGURATION_BASED("configuration_based"),
        CUSTOM("custom");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        REPEATABLE_READ("repeatable_read"),
        READ_COMMITTED("read_committed"),
        READ_UNCOMMITTED("read_uncommitted");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        SHARE("share"),
        CUSTOM("custom");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

