/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import com.informix.jdbc.IfxDriver;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.InformixOffsetContext;
import io.debezium.connector.informix.Lsn;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Instant;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformixConnection
extends JdbcConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformixConnection.class);
    private static final String GET_DATABASE_NAME = "select dbinfo('dbname') as dbname from systables where tabid = 1";
    private static final String GET_MAX_LSN = "select uniqid, used as logpage from sysmaster:syslogs where is_current = 1";
    private static final String GET_MIN_LSN = "select min(uniqid) as uniqid , 0 as logpage from sysmaster:syslogs";
    private static final String GET_CURRENT_TIMESTAMP = "select sysdate as sysdate from sysmaster:sysdual";
    private static final String QUOTED_CHARACTER = "";
    private static final String URL_PATTERN = "jdbc:informix-sqli://${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}:user=${" + JdbcConfiguration.USER + "};password=${" + JdbcConfiguration.PASSWORD + "}";
    private static final JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)URL_PATTERN, (String)IfxDriver.class.getName(), (ClassLoader)InformixConnection.class.getClassLoader(), (Field[])new Field[]{JdbcConfiguration.PORT.withDefault(InformixConnectorConfig.PORT.defaultValueAsString())});
    private final String realDatabaseName = this.retrieveRealDatabaseName().trim();

    public InformixConnection(JdbcConfiguration config) {
        super(config, FACTORY, QUOTED_CHARACTER, QUOTED_CHARACTER);
    }

    public Lsn getMaxLsn() throws SQLException {
        return (Lsn)this.queryAndMap(GET_MAX_LSN, this.singleResultMapper(rs -> {
            Lsn lsn = Lsn.of(rs.getLong("uniqid"), rs.getLong("logpage") << 12);
            LOGGER.trace("Current maximum lsn is {}", (Object)lsn.toLongString());
            return lsn;
        }, "Maximum LSN query must return exactly one value"));
    }

    public String getRealDatabaseName() {
        return this.realDatabaseName;
    }

    private String retrieveRealDatabaseName() {
        try {
            return (String)this.queryAndMap(GET_DATABASE_NAME, this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    public String connectionString() {
        return this.connectionString(URL_PATTERN);
    }

    public Optional<Instant> getCurrentTimestamp() throws SQLException {
        return (Optional)this.queryAndMap(GET_CURRENT_TIMESTAMP, rs -> rs.next() ? Optional.of(rs.getTimestamp(1).toInstant()) : Optional.empty());
    }

    public Optional<Boolean> nullsSortLast() {
        return Optional.of(false);
    }

    public String quotedTableIdString(TableId tableId) {
        String schemaName;
        StringBuilder builder = new StringBuilder();
        String catalogName = tableId.catalog();
        if (!Strings.isNullOrBlank((String)catalogName)) {
            builder.append(catalogName).append(':');
        }
        if (!Strings.isNullOrBlank((String)(schemaName = tableId.schema()))) {
            builder.append(schemaName).append('.');
        }
        return builder.append(tableId.table()).toString();
    }

    public String quotedColumnIdString(String columnName) {
        return columnName;
    }

    public Table getTableSchemaFromTableId(TableId tableId) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        try (ResultSet columns = metadata.getColumns(tableId.catalog(), tableId.schema(), tableId.table(), null);){
            TableEditor tableEditor = Table.editor().tableId(tableId);
            while (columns.next()) {
                this.readTableColumn(columns, tableId, null).ifPresent(columnEditor -> tableEditor.addColumns(new Column[]{columnEditor.create()}));
            }
            tableEditor.setPrimaryKeyNames(this.readPrimaryKeyNames(metadata, tableId));
            Table table = tableEditor.create();
            return table;
        }
    }

    public DataSource datasource() {
        return new DataSource(){

            @Override
            public Connection getConnection() throws SQLException {
                return InformixConnection.this.connection();
            }

            @Override
            public Connection getConnection(String username, String password) throws SQLException {
                JdbcConfiguration config = (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)InformixConnection.this.config()).with(JdbcConfiguration.USER, username)).with(JdbcConfiguration.PASSWORD, password)).build();
                return FACTORY.connect(config);
            }

            @Override
            public PrintWriter getLogWriter() {
                throw new UnsupportedOperationException("getLogWriter");
            }

            @Override
            public void setLogWriter(PrintWriter out) {
                throw new UnsupportedOperationException("setLogWriter");
            }

            @Override
            public void setLoginTimeout(int seconds) {
                throw new UnsupportedOperationException("setLoginTimeout");
            }

            @Override
            public int getLoginTimeout() {
                return 0;
            }

            @Override
            public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
                throw new SQLFeatureNotSupportedException("getParentLogger");
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                if (iface.isInstance(this)) {
                    return (T)this;
                }
                throw new SQLException("DataSource of type [" + this.getClass().getName() + "] cannot be unwrapped as [" + iface.getName() + "]");
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return iface.isInstance(this);
            }
        };
    }

    public boolean validateLogPosition(Partition partition, OffsetContext offset, CommonConnectorConfig config) {
        Lsn storedLsn = ((InformixOffsetContext)offset).getChangePosition().getCommitLsn();
        try {
            Lsn oldestLsn = this.getOldestLsn();
            if (oldestLsn == null) {
                return false;
            }
            LOGGER.trace("Oldest SCN in logs is '{}'", (Object)oldestLsn);
            return storedLsn == null || oldestLsn.compareTo(storedLsn) < 0;
        }
        catch (SQLException e) {
            throw new DebeziumException("Unable to get last available log position", (Throwable)e);
        }
    }

    private Lsn getOldestLsn() throws SQLException {
        return (Lsn)this.queryAndMap(GET_MIN_LSN, this.singleResultMapper(rs -> {
            Lsn lsn = Lsn.of(rs.getLong("uniqid"), rs.getLong("logpage") << 12);
            LOGGER.trace("Current minimum lsn is {}", (Object)lsn.toLongString());
            return lsn;
        }, "Minimum LSN query must return exactly one value"));
    }
}

