/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.processors.AbstractReselectProcessorTest;
import io.debezium.processors.reselect.ReselectColumnsPostProcessor;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;

public class InformixReselectColumnsProcessorIT
extends AbstractReselectProcessorTest<InformixConnector> {
    private InformixConnection connection;

    @Before
    public void beforeEach() throws Exception {
        this.connection = TestHelper.testConnection();
        this.connection.setAutoCommit(false);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        this.stopConnector();
        InformixReselectColumnsProcessorIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        super.afterEach();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{"DROP TABLE dbz4321"}).close();
        }
    }

    protected Class<InformixConnector> getConnectorClass() {
        return InformixConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected Configuration.Builder getConfigurationBuilder() {
        return ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.CUSTOM_POST_PROCESSORS, "reselector")).with("reselector.type", ReselectColumnsPostProcessor.class.getName());
    }

    protected String topicName() {
        return "testdb.informix.dbz4321";
    }

    protected String tableName() {
        return "informix.dbz4321";
    }

    protected String reselectColumnsList() {
        return "informix.dbz4321:data";
    }

    protected void createTable() throws Exception {
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS DBZ4321"});
        this.connection.execute(new String[]{"CREATE TABLE DBZ4321 (id int not null, data varchar(50), data2 int, primary key(id))"});
    }

    protected void dropTable() throws Exception {
    }

    protected String getInsertWithValue() {
        return "INSERT INTO dbz4321 (id,data,data2) values (1,'one',1)";
    }

    protected String getInsertWithNullValue() {
        return "INSERT INTO dbz4321 (id,data,data2) values (1,null,1)";
    }

    protected void waitForStreamingStarted() throws InterruptedException {
        InformixReselectColumnsProcessorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        InformixReselectColumnsProcessorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
    }

    protected AbstractConnectorTest.SourceRecords consumeRecordsByTopicReselectWhenNullStreaming() throws InterruptedException {
        this.waitForAvailableRecords(10L, TimeUnit.SECONDS);
        return super.consumeRecordsByTopicReselectWhenNullStreaming();
    }

    protected AbstractConnectorTest.SourceRecords consumeRecordsByTopicReselectWhenNotNullStreaming() throws InterruptedException {
        this.waitForAvailableRecords(10L, TimeUnit.SECONDS);
        return super.consumeRecordsByTopicReselectWhenNotNullStreaming();
    }
}

