/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.connector.informix.AbstractInformixDefaultValueIT;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.data.VerifyRecord;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;

public class InformixOfflineDefaultValueIT
extends AbstractInformixDefaultValueIT {
    @Override
    @Before
    public void before() throws SQLException {
        super.before();
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
    }

    @Override
    protected void performSchemaChange(Configuration config, InformixConnection connection, String alterStatement) throws Exception {
        this.stopConnector();
        InformixOfflineDefaultValueIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        TableId tableId = TableId.parse((String)"informix.dv_test", (boolean)false);
        String sourceTable = alterStatement.replace("%table%", tableId.table());
        connection.execute(new String[]{sourceTable});
        this.start(InformixConnector.class, config);
        InformixOfflineDefaultValueIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.assertConnectorIsRunning();
        this.waitForAvailableRecords(1L, TimeUnit.SECONDS);
    }
}

