/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Field;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class InformixConnectorTest {
    protected static void assertConfigDefIsValid(Connector connector, Field.Set fields) {
        ConfigDef configDef = connector.config();
        Assertions.assertThat((Object)configDef).isNotNull();
        fields.forEach(expected -> {
            Assertions.assertThat((Iterable)configDef.names()).contains((Object[])new String[]{expected.name()});
            ConfigDef.ConfigKey key = (ConfigDef.ConfigKey)configDef.configKeys().get(expected.name());
            Assertions.assertThat((Object)key).isNotNull();
            Assertions.assertThat((String)key.name).isEqualTo((Object)expected.name());
            Assertions.assertThat((String)key.displayName).isEqualTo((Object)expected.displayName());
            Assertions.assertThat((Comparable)key.importance).isEqualTo((Object)expected.importance());
            Assertions.assertThat((String)key.documentation).isEqualTo((Object)expected.description());
            Assertions.assertThat((Comparable)key.type).isEqualTo((Object)expected.type());
            if (expected.equals((Object)InformixConnectorConfig.SCHEMA_HISTORY)) {
                Assertions.assertThat((String)((Class)key.defaultValue).getName()).isEqualTo(expected.defaultValue());
            }
            Assertions.assertThat((List)key.dependents).isEqualTo((Object)expected.dependents());
            Assertions.assertThat((Comparable)key.width).isNotNull();
            Assertions.assertThat((String)key.group).isNotNull();
            Assertions.assertThat((int)key.orderInGroup).isPositive();
            Assertions.assertThat((Object)key.validator).isNull();
            Assertions.assertThat((Object)key.recommender).isNull();
        });
    }

    @Test
    public void shouldReturnConfigurationDefinition() {
        InformixConnectorTest.assertConfigDefIsValid((Connector)new InformixConnector(), InformixConnectorConfig.ALL_FIELDS);
    }
}

