/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import com.informix.jdbc.IfmxReadableType;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.InformixOffsetContext;
import io.debezium.connector.informix.InformixPartition;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.kafka.connect.data.Field;

public class InformixChangeRecordEmitter
extends RelationalChangeRecordEmitter<InformixPartition> {
    private final Envelope.Operation operation;
    private final Object[] before;
    private final Object[] after;

    public InformixChangeRecordEmitter(InformixPartition partition, InformixOffsetContext offsetContext, Envelope.Operation operation, Object[] before, Object[] after, Clock clock, InformixConnectorConfig connectorConfig) {
        super((Partition)partition, (OffsetContext)offsetContext, clock, (RelationalDatabaseConnectorConfig)connectorConfig);
        this.operation = operation;
        this.before = before;
        this.after = after;
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    protected Object[] getOldColumnValues() {
        return this.before;
    }

    protected Object[] getNewColumnValues() {
        return this.after;
    }

    protected void emitTruncateRecord(ChangeRecordEmitter.Receiver<InformixPartition> receiver, TableSchema tableSchema) throws InterruptedException {
        receiver.changeRecord((Partition)((InformixPartition)this.getPartition()), (DataCollectionSchema)tableSchema, Envelope.Operation.TRUNCATE, null, tableSchema.getEnvelopeSchema().truncate(this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant()), this.getOffset(), null);
    }

    public static Object[] convertIfxData2Array(Map<String, IfmxReadableType> data, TableSchema tableSchema) {
        return data == null ? new Object[]{} : tableSchema.valueSchema().fields().stream().map(Field::name).map(data::get).map(irt -> InformixChangeRecordEmitter.propagate(() -> ((IfmxReadableType)irt).toObject())).toArray();
    }

    private static <X> X propagate(Callable<X> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }
}

