/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import com.informix.stream.api.IfmxStreamRecord;
import com.informix.stream.api.IfmxStreamRecordType;
import com.informix.stream.api.IfxTransactionEngine;
import com.informix.stream.cdc.IfxCDCEngine;
import com.informix.stream.cdc.records.IfxCDCBeginTransactionRecord;
import com.informix.stream.impl.IfxStreamException;
import io.debezium.connector.informix.InformixStreamTransactionRecord;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformixCdcTransactionEngine
implements IfxTransactionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformixCdcTransactionEngine.class);
    private static final String PROCESSING_RECORD = "Processing {} record";
    private static final String MISSING_TRANSACTION_START_FOR_RECORD = "Missing transaction start for record: {}";
    protected final Map<Integer, TransactionHolder> transactionMap;
    protected final IfxCDCEngine engine;
    private final ChangeEventSource.ChangeEventSourceContext context;
    protected EnumSet<IfmxStreamRecordType> operationFilters;
    protected EnumSet<IfmxStreamRecordType> transactionFilters;
    protected boolean returnEmptyTransactions;
    private Map<String, TableId> tableIdByLabelId;

    public InformixCdcTransactionEngine(ChangeEventSource.ChangeEventSourceContext context, IfxCDCEngine engine) {
        this.context = context;
        this.operationFilters = EnumSet.of(IfmxStreamRecordType.INSERT, IfmxStreamRecordType.DELETE, IfmxStreamRecordType.BEFORE_UPDATE, IfmxStreamRecordType.AFTER_UPDATE, IfmxStreamRecordType.TRUNCATE);
        this.transactionFilters = EnumSet.of(IfmxStreamRecordType.COMMIT, IfmxStreamRecordType.ROLLBACK);
        this.transactionMap = new ConcurrentHashMap<Integer, TransactionHolder>();
        this.returnEmptyTransactions = true;
        this.engine = engine;
    }

    public IfmxStreamRecord getRecord() throws SQLException, IfxStreamException {
        IfmxStreamRecord streamRecord;
        while (this.context.isRunning() && (streamRecord = this.engine.getRecord()) != null) {
            TransactionHolder holder = this.transactionMap.get(streamRecord.getTransactionId());
            if (holder != null) {
                LOGGER.debug("Processing [{}] record for transaction id: {}", (Object)streamRecord.getType(), (Object)streamRecord.getTransactionId());
            }
            switch (streamRecord.getType()) {
                case BEGIN: {
                    holder = new TransactionHolder();
                    holder.beginRecord = (IfxCDCBeginTransactionRecord)streamRecord;
                    this.transactionMap.put(streamRecord.getTransactionId(), holder);
                    LOGGER.debug("Watching transaction id: {}", (Object)streamRecord.getTransactionId());
                    break;
                }
                case INSERT: 
                case DELETE: 
                case BEFORE_UPDATE: 
                case AFTER_UPDATE: 
                case TRUNCATE: {
                    if (holder == null) {
                        LOGGER.warn(MISSING_TRANSACTION_START_FOR_RECORD, (Object)streamRecord);
                        break;
                    }
                    LOGGER.debug(PROCESSING_RECORD, (Object)streamRecord.getType());
                    holder.records.add(streamRecord);
                    break;
                }
                case DISCARD: {
                    if (holder == null) {
                        LOGGER.warn(MISSING_TRANSACTION_START_FOR_RECORD, (Object)streamRecord);
                        break;
                    }
                    LOGGER.debug(PROCESSING_RECORD, (Object)streamRecord.getType());
                    long sequenceId = streamRecord.getSequenceId();
                    if (!holder.records.removeIf(r -> r.getSequenceId() >= sequenceId)) break;
                    LOGGER.debug("Discarding records with sequence >={}", (Object)sequenceId);
                    break;
                }
                case COMMIT: 
                case ROLLBACK: {
                    if (holder == null) {
                        LOGGER.warn(MISSING_TRANSACTION_START_FOR_RECORD, (Object)streamRecord);
                        break;
                    }
                    LOGGER.debug(PROCESSING_RECORD, (Object)streamRecord.getType());
                    holder.closingRecord = streamRecord;
                    break;
                }
                case METADATA: 
                case TIMEOUT: 
                case ERROR: {
                    if (holder == null) {
                        return streamRecord;
                    }
                    LOGGER.debug(PROCESSING_RECORD, (Object)streamRecord.getType());
                    holder.records.add(streamRecord);
                    break;
                }
                default: {
                    LOGGER.warn("Unknown operation for record: {}", (Object)streamRecord);
                }
            }
            if (holder == null || holder.closingRecord == null) continue;
            this.transactionMap.remove(streamRecord.getTransactionId());
            if (holder.records.isEmpty() && !this.returnEmptyTransactions) continue;
            return new InformixStreamTransactionRecord(holder.beginRecord, holder.closingRecord, holder.records);
        }
        return null;
    }

    public InformixStreamTransactionRecord getTransaction() throws SQLException, IfxStreamException {
        IfmxStreamRecord streamRecord;
        while ((streamRecord = this.getRecord()) != null && !(streamRecord instanceof InformixStreamTransactionRecord)) {
            LOGGER.debug("Discard non-transaction record: {}", (Object)streamRecord);
        }
        return (InformixStreamTransactionRecord)streamRecord;
    }

    public InformixCdcTransactionEngine setOperationFilters(IfmxStreamRecordType ... recordTypes) {
        this.operationFilters = EnumSet.copyOf(Set.of(recordTypes));
        return this;
    }

    public InformixCdcTransactionEngine setTransactionFilters(IfmxStreamRecordType ... recordTypes) {
        this.transactionFilters = EnumSet.copyOf(Set.of(recordTypes));
        return this;
    }

    public InformixCdcTransactionEngine returnEmptyTransactions(boolean returnEmptyTransactions) {
        this.returnEmptyTransactions = returnEmptyTransactions;
        return this;
    }

    public void init() throws SQLException, IfxStreamException {
        this.engine.init();
        this.tableIdByLabelId = this.engine.getBuilder().getWatchedTables().stream().collect(Collectors.toUnmodifiableMap(o -> String.valueOf(o.getLabel()), t -> new TableId(t.getDatabaseName(), t.getNamespace(), t.getTableName())));
    }

    public void close() throws IfxStreamException {
        this.engine.close();
    }

    public OptionalLong getLowestBeginSequence() {
        return this.transactionMap.values().stream().mapToLong(t -> t.beginRecord.getSequenceId()).min();
    }

    public Map<String, TableId> getTableIdByLabelId() {
        return this.tableIdByLabelId;
    }

    protected static class TransactionHolder {
        final List<IfmxStreamRecord> records = new ArrayList<IfmxStreamRecord>();
        IfxCDCBeginTransactionRecord beginRecord;
        IfmxStreamRecord closingRecord;

        protected TransactionHolder() {
        }
    }
}

