/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.informix.Lsn;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LsnTest {
    @Test
    public void testLsnMinusOne() {
        Lsn recorded = Lsn.of((String)"1000");
        Lsn desired = Lsn.of((String)"1046");
        int ret = recorded.compareTo(desired);
        System.out.println(ret);
        System.out.println(146031505564L);
        System.out.println(Long.MAX_VALUE);
        Long l1 = 0L;
        Long l2 = 146031505564L;
        System.out.println(Long.toHexString(l1));
        System.out.println(Long.toHexString(l2));
    }

    @Test
    public void testLsnNULL() {
        Lsn recorded = Lsn.NULL;
        Lsn desired = Lsn.of((String)"146031505564");
        Assertions.assertThat((Comparable)recorded).isLessThan((Comparable)desired);
        Lsn recorded1 = Lsn.of((String)"NULL");
        Lsn desired1 = Lsn.of((String)"146031505564");
        Assertions.assertThat((Comparable)recorded1).isLessThan((Comparable)desired1);
    }

    @Test
    public void testValueOf() {
        String lsnStr = "146039087264";
        Lsn lsn1 = Lsn.of((String)lsnStr);
        Lsn lsn2 = Lsn.of((Long)146039087264L);
        Lsn lsn3 = new Lsn(Long.valueOf(146039087264L));
        Assertions.assertThat((Comparable)lsn1).isEqualTo((Object)lsn2);
        Assertions.assertThat((Comparable)lsn2).isEqualTo((Object)lsn3);
    }

    @Test
    public void testLsnCompare() {
        Lsn lsnNegativeOne = new Lsn(Long.valueOf(-1L));
        Lsn lsnOne = new Lsn(Long.valueOf(1L));
        Lsn lsn1 = new Lsn(Long.valueOf(146039087264L));
        Lsn lsn2 = new Lsn(Long.valueOf(146039087265L));
        Lsn lsn3 = new Lsn(Long.valueOf(1460390872640L));
        Lsn lsnMaxVal = new Lsn(Long.valueOf(Long.MAX_VALUE));
        Assertions.assertThat((Comparable)lsnNegativeOne).isLessThan((Comparable)lsnOne);
        Assertions.assertThat((Comparable)lsnOne).isLessThan((Comparable)lsn1);
        Assertions.assertThat((Comparable)lsn1).isLessThan((Comparable)lsn2);
        Assertions.assertThat((Comparable)lsn2).isLessThan((Comparable)lsn3);
        Assertions.assertThat((Comparable)lsn3).isLessThan((Comparable)lsnMaxVal);
        Assertions.assertThat((Comparable)lsnOne).isGreaterThan((Comparable)lsnNegativeOne);
        Assertions.assertThat((Comparable)lsn1).isGreaterThan((Comparable)lsnOne);
        Assertions.assertThat((Comparable)lsn2).isGreaterThan((Comparable)lsn1);
        Assertions.assertThat((Comparable)lsn3).isGreaterThan((Comparable)lsn2);
        Assertions.assertThat((Comparable)lsnMaxVal).isGreaterThan((Comparable)lsn3);
    }

    @Test
    public void testLsnValueOf() {
        Lsn lsnNegativeOne = Lsn.of((Long)-1L);
        Lsn lsnNegativeOneStr = Lsn.of((String)"-1");
        Lsn lsnDigit1 = Lsn.of((String)"1");
        Lsn lsnDigit2 = Lsn.of((String)"12");
        Lsn lsnDigit3 = Lsn.of((String)"123");
        Lsn lsnDigit4 = Lsn.of((String)"1234");
        Lsn lsnDigit5 = Lsn.of((String)"12345");
        Lsn lsnDigit6 = Lsn.of((String)"123456");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)lsnNegativeOne).isEqualTo((Object)lsnNegativeOneStr)).isEqualByComparingTo((Comparable)lsnNegativeOneStr);
        Assertions.assertThat((Comparable)lsnDigit1).isLessThan((Comparable)lsnDigit2);
        Assertions.assertThat((Comparable)lsnDigit2).isLessThan((Comparable)lsnDigit3);
        Assertions.assertThat((Comparable)lsnDigit3).isLessThan((Comparable)lsnDigit4);
        Assertions.assertThat((Comparable)lsnDigit4).isLessThan((Comparable)lsnDigit5);
        Assertions.assertThat((Comparable)lsnDigit5).isLessThan((Comparable)lsnDigit6);
        Assertions.assertThat((Comparable)lsnDigit2).isGreaterThan((Comparable)lsnDigit1);
        Assertions.assertThat((Comparable)lsnDigit3).isGreaterThan((Comparable)lsnDigit2);
        Assertions.assertThat((Comparable)lsnDigit4).isGreaterThan((Comparable)lsnDigit3);
        Assertions.assertThat((Comparable)lsnDigit5).isGreaterThan((Comparable)lsnDigit4);
        Assertions.assertThat((Comparable)lsnDigit6).isGreaterThan((Comparable)lsnDigit5);
    }

    @Test
    public void testLsnLongString() {
        Lsn lsn = Lsn.of((String)"30073823388");
        Assertions.assertThat((String)lsn.toLongString()).isEqualTo((Object)"LSN(7,8a209c)");
    }
}

