/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.junit.ConditionalFail;
import io.debezium.junit.Flaky;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public abstract class AbstractInformixDefaultValueIT
extends AbstractConnectorTest {
    @Rule
    public TestRule conditionalFail = new ConditionalFail();
    private InformixConnection connection;
    private Configuration config;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS dv_test"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        AbstractInformixDefaultValueIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{"DROP TABLE IF EXISTS dv_test"}).close();
        }
    }

    @Test
    @Flaky(value="DBZ-7542")
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleBooleanDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = List.of(new ColumnDefinition("val_boolean", "BOOLEAN", "'t'", "'f'", true, false, AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @Flaky(value="DBZ-7542")
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleNumericDefaultTypes() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        List<ColumnDefinition> columnDefinitions = List.of(new ColumnDefinition("val_bigint", "BIGINT", "1", "2", 1L, 2L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_integer", "INTEGER", "1", "2", 1, 2, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_smallint", "SMALLINT", "1", "2", (short)1, (short)2, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_decimal", "DECIMAL(5,0)", "314", "628", BigDecimal.valueOf(314L), BigDecimal.valueOf(628L), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_numeric", "NUMERIC(5,0)", "314", "628", BigDecimal.valueOf(314L), BigDecimal.valueOf(628L), AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @Flaky(value="DBZ-7542")
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleFloatPointDefaultTypes() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_double", "DOUBLE PRECISION", "3.14", "6.28", 3.14, 6.28, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_float", "FLOAT", "3.14", "6.28", 3.14, 6.28, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_real", "REAL", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_decimal", "DECIMAL(5,2)", "3.14", "6.28", BigDecimal.valueOf(3.14), BigDecimal.valueOf(6.28), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_numeric", "NUMERIC(5,2)", "3.14", "6.28", BigDecimal.valueOf(3.14), BigDecimal.valueOf(6.28), AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @Flaky(value="DBZ-7542")
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleCharacterDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_char", "char(5)", "'YES'", "'NO'", "YES  ", "NO   ", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_varchar", "VARCHAR(100)", "'hello'", "'world'", "hello", "world", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_lvarchar", "LVARCHAR(1000)", "'hello'", "'world'", "hello", "world", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nchar", "NCHAR(5)", "'ON'", "'OFF'", "ON   ", "OFF  ", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nvarchar", "NVARCHAR(100)", "'cedric'", "'entertainer'", "cedric", "entertainer", AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @Flaky(value="DBZ-7542")
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleDateTimeDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_date", "DATE", "'2024-01-01'", "'2024-01-02'", 19723, 19724, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_time", "DATETIME HOUR TO SECOND", "DATETIME(01:02:03) HOUR TO SECOND", "DATETIME(02:03:04) HOUR TO SECOND", 3723000000L, 7384000000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_datetime", "DATETIME YEAR TO SECOND", "DATETIME(2024-01-01 01:02:03) YEAR TO SECOND", "DATETIME(2024-01-02 01:02:03) YEAR TO SECOND", 1704070923000L, 1704157323000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_timestamp", "DATETIME YEAR TO FRACTION", "DATETIME(2024-01-01 01:02:03.003) YEAR TO FRACTION", "DATETIME(2024-01-02 01:02:03.003) YEAR TO FRACTION", 1704070923003L, 1704157323003L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_timestamp_us", "DATETIME YEAR TO FRACTION(5)", "DATETIME(2024-01-01 01:02:03.00005) YEAR TO FRACTION(5)", "DATETIME(2024-01-02 01:02:03.00005) YEAR TO FRACTION(5)", 1704070923000050L, 1704157323000050L, AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    protected abstract void performSchemaChange(Configuration var1, InformixConnection var2, String var3) throws Exception;

    private void shouldHandleDefaultValuesCommon(List<ColumnDefinition> columnDefinitions) throws Exception {
        this.testDefaultValuesCreateTableAndSnapshot(columnDefinitions);
        this.testDefaultValuesAlterTableModifyExisting(columnDefinitions);
        this.testDefaultValuesAlterTableAdd(columnDefinitions);
        this.testDefaultValuesByRestartAndLoadingHistoryTopic();
    }

    private void testDefaultValuesByRestartAndLoadingHistoryTopic() throws Exception {
        this.stopConnector();
        this.start(InformixConnector.class, this.config);
        this.assertConnectorIsRunning();
        AbstractInformixDefaultValueIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
    }

    private void testDefaultValuesCreateTableAndSnapshot(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder createSql = new StringBuilder();
        createSql.append("CREATE TABLE dv_test (id INTEGER NOT NULL PRIMARY KEY");
        for (ColumnDefinition column : columnDefinitions) {
            createSql.append(", ").append(column.name).append(" ").append(column.definition).append(" ").append("DEFAULT ").append(column.addDefaultValue);
            createSql.append(", ").append(column.name).append("_null").append(" ").append(column.definition).append(" ").append("DEFAULT NULL");
            if (!column.temporalType) continue;
            String currentDefaultValue = column.getCurrentRegister();
            createSql.append(", ").append(column.name).append("_current").append(" ").append(column.definition).append(" ").append("DEFAULT ").append(currentDefaultValue);
            createSql.append(", ").append(column.name).append("_current_nonnull").append(" ").append(column.definition).append(" ").append("DEFAULT ").append(currentDefaultValue).append(" NOT NULL");
        }
        createSql.append(')');
        this.connection.execute(new String[]{createSql.toString()});
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) VALUES (0)"});
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.TABLE_INCLUDE_LIST, "testdb.informix.dv_test")).with(InformixConnectorConfig.CDC_BUFFERSIZE, 2048)).with(InformixConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.ADAPTIVE_TIME_MICROSECONDS)).build();
        this.start(InformixConnector.class, this.config);
        this.assertConnectorIsRunning();
        AbstractInformixDefaultValueIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableRecords = records.recordsForTopic("testdb.informix.dv_test");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        this.assertNoRecordsToConsume();
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        VerifyRecord.isValidRead((SourceRecord)record, (String)"id", (int)0);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toLowerCase(), column.expectedAddDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toLowerCase() + "_null", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toLowerCase(), column.expectedAddDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toLowerCase() + "_null", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current", null);
            if (column.definition.equalsIgnoreCase("DATE")) {
                AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current_nonnull", 0);
                continue;
            }
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current_nonnull", 0L);
        }
        AbstractInformixDefaultValueIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) values (1)"});
        records = this.consumeRecordsByTopic(1);
        tableRecords = records.recordsForTopic("testdb.informix.dv_test");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        this.assertNoRecordsToConsume();
        record = (SourceRecord)tableRecords.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"id", (int)1);
    }

    private void testDefaultValuesAlterTableModifyExisting(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder alterSql = new StringBuilder();
        alterSql.append("ALTER TABLE %table% MODIFY (");
        for (ColumnDefinition column : columnDefinitions) {
            alterSql.append(column.name).append(' ').append(column.definition).append(" DEFAULT ").append(column.modifyDefaultValue).append(", ").append(column.name).append("_null ").append(column.definition).append(" DEFAULT NULL, ");
        }
        alterSql.replace(alterSql.length() - 2, alterSql.length(), ")");
        this.performSchemaChange(this.config, this.connection, alterSql.toString());
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) values (2)"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableRecords = records.recordsForTopic("testdb.informix.dv_test");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        this.assertNoRecordsToConsume();
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"id", (int)2);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toLowerCase(), column.expectedModifyDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toLowerCase() + "_null", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toLowerCase(), column.expectedModifyDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toLowerCase() + "_null", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current", null);
            if (column.definition.equalsIgnoreCase("DATE")) {
                AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current_nonnull", 0);
                continue;
            }
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current_nonnull", 0L);
        }
    }

    private void testDefaultValuesAlterTableAdd(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder alterSql = new StringBuilder();
        alterSql.append("ALTER TABLE %table% ");
        for (ColumnDefinition column : columnDefinitions) {
            alterSql.append("ADD (").append("a").append(column.name).append(" ").append(column.definition).append(" ").append("DEFAULT ").append(column.addDefaultValue).append("), ");
            alterSql.append(" ADD (").append("a").append(column.name).append("_null").append(" ").append(column.definition).append(" ").append("DEFAULT NULL ").append("), ");
            if (!column.temporalType) continue;
            String currentDefaultValue = column.getCurrentRegister();
            alterSql.append(" ADD (").append("a").append(column.name).append("_current").append(" ").append(column.definition).append(" ").append("DEFAULT ").append(currentDefaultValue).append("), ");
            alterSql.append(" ADD (").append("a").append(column.name).append("_current_nonnull").append(" ").append(column.definition).append(" ").append("DEFAULT ").append(currentDefaultValue).append(" NOT NULL ").append("), ");
        }
        alterSql.replace(alterSql.length() - 2, alterSql.length(), "");
        this.performSchemaChange(this.config, this.connection, alterSql.toString());
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) values (3)"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(4);
        this.assertNoRecordsToConsume();
        List tableRecords = records.recordsForTopic("testdb.informix.dv_test");
        SourceRecord record = (SourceRecord)tableRecords.get(tableRecords.size() - 1);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"id", (int)3);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toLowerCase(), column.expectedModifyDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toLowerCase() + "_null", null);
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, "a" + column.name.toLowerCase(), column.expectedAddDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, "a" + column.name.toLowerCase() + "_null", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toLowerCase(), column.expectedModifyDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toLowerCase() + "_null", null);
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, "a" + column.name.toLowerCase(), column.expectedAddDefaultValue);
                    AbstractInformixDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, "a" + column.name.toLowerCase() + "_null", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current", null);
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, "a" + column.name.toLowerCase() + "_current", null);
            if (column.definition.equalsIgnoreCase("DATE")) {
                AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current_nonnull", 0);
                AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, "a" + column.name.toLowerCase() + "_current_nonnull", 0);
                continue;
            }
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, column.name.toLowerCase() + "_current_nonnull", 0L);
            AbstractInformixDefaultValueIT.assertSchemaFieldWithDefaultCurrentDateTime(record, "a" + column.name.toLowerCase() + "_current_nonnull", 0L);
        }
    }

    private static void assertSchemaFieldWithSameDefaultAndValue(SourceRecord record, String fieldName, Object expectedValue) {
        AbstractInformixDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, expectedValue, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isEqualTo(expectedValue));
    }

    private static void assertSchemaFieldNoDefaultWithValue(SourceRecord record, String fieldName, Object fieldValue) {
        AbstractInformixDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, null, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isEqualTo(fieldValue));
    }

    private static void assertSchemaFieldValueWithDefault(SourceRecord record, String fieldName, Object expectedDefault, Consumer<Object> valueCheck) {
        Struct after = ((Struct)record.value()).getStruct("after");
        Field field = after.schema().field(fieldName);
        ((ObjectAssert)Assertions.assertThat((Object)field).as("Expected non-null field for " + fieldName, new Object[0])).isNotNull();
        Object defaultValue = field.schema().defaultValue();
        if (expectedDefault == null) {
            Assertions.assertThat((Object)defaultValue).isNull();
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)defaultValue).as("Expected non-null default value for field " + fieldName, new Object[0])).isNotNull();
        Assertions.assertThat(defaultValue.getClass()).isEqualTo(expectedDefault.getClass());
        ((ObjectAssert)Assertions.assertThat((Object)defaultValue).as("Unexpected default value: " + fieldName + " with field value: " + after.get(fieldName), new Object[0])).isEqualTo(expectedDefault);
        valueCheck.accept(after.get(fieldName));
    }

    private static void assertSchemaFieldWithDefaultCurrentDateTime(SourceRecord record, String fieldName, Object expectedValue) {
        AbstractInformixDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, expectedValue, v -> {
            if (expectedValue == null) {
                Assertions.assertThat((Object)v).isNull();
            } else if (expectedValue instanceof Long) {
                ((AbstractLongAssert)Assertions.assertThat((Long)((Long)v)).as("Unexpected field value: " + fieldName, new Object[0])).isGreaterThan(1L);
            } else if (expectedValue instanceof Integer) {
                ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)v)).as("Unexpected field value: " + fieldName, new Object[0])).isGreaterThan(1);
            }
        });
    }

    private static void assertSchemaFieldDefaultAndNonNullValue(SourceRecord record, String fieldName, Object defaultValue) {
        AbstractInformixDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, defaultValue, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isNotNull());
    }

    private static class ColumnDefinition {
        public final String name;
        public final String definition;
        public final String addDefaultValue;
        public final String modifyDefaultValue;
        public final Object expectedAddDefaultValue;
        public final Object expectedModifyDefaultValue;
        public final AssertionType assertionType;
        public final boolean temporalType;

        ColumnDefinition(String name, String definition, String addDefaultValue, String modifyDefaultValue, Object expectedAddDefaultValue, Object expectedModifyDefaultValue, AssertionType assertionType) {
            this.name = name;
            this.definition = definition;
            this.addDefaultValue = addDefaultValue;
            this.modifyDefaultValue = modifyDefaultValue;
            this.expectedAddDefaultValue = expectedAddDefaultValue;
            this.expectedModifyDefaultValue = expectedModifyDefaultValue;
            this.assertionType = assertionType;
            this.temporalType = definition.toUpperCase().startsWith("DATE");
        }

        public String getCurrentRegister() {
            if (this.definition.equalsIgnoreCase("DATE")) {
                return "TODAY";
            }
            if (this.definition.toUpperCase().startsWith("DATETIME")) {
                if (this.definition.toUpperCase().contains("FRACTION")) {
                    return "SYSDATE" + this.definition.toUpperCase().substring(8);
                }
                return "CURRENT" + this.definition.toUpperCase().substring(8);
            }
            throw new RuntimeException("Unexpected temporal type for current time register: " + this.definition);
        }
    }

    static enum AssertionType {
        FIELD_DEFAULT_EQUAL,
        FIELD_NO_DEFAULT;

    }
}

