/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.Lsn;
import io.debezium.connector.informix.SourceInfo;
import io.debezium.connector.informix.TxLogPosition;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class InformixOffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private boolean snapshotCompleted;

    public InformixOffsetContext(InformixConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        super((BaseSourceInfo)new SourceInfo(connectorConfig));
        ((SourceInfo)this.sourceInfo).setCommitLsn(position.getCommitLsn());
        ((SourceInfo)this.sourceInfo).setChangeLsn(position.getChangeLsn());
        ((SourceInfo)this.sourceInfo).setBeginLsn(position.getBeginLsn());
        this.sourceInfoSchema = ((SourceInfo)this.sourceInfo).schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            ((SourceInfo)this.sourceInfo).setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public InformixOffsetContext(InformixConnectorConfig connectorConfig, TxLogPosition position, boolean snapshot, boolean snapshotCompleted) {
        this(connectorConfig, position, snapshot, snapshotCompleted, new TransactionContext(), (IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext(false));
    }

    public Map<String, ?> getOffset() {
        if (((SourceInfo)this.sourceInfo).isSnapshot()) {
            return Collect.hashMapOf((Object)"snapshot", (Object)true, (Object)SNAPSHOT_COMPLETED_KEY, (Object)this.snapshotCompleted, (Object)"commit_lsn", (Object)((SourceInfo)this.sourceInfo).getCommitLsn().toString());
        }
        return this.incrementalSnapshotContext.store(this.transactionContext.store(Collect.hashMapOf((Object)"commit_lsn", (Object)((SourceInfo)this.sourceInfo).getCommitLsn().toString(), (Object)"change_lsn", (Object)(((SourceInfo)this.sourceInfo).getChangeLsn() == null ? null : ((SourceInfo)this.sourceInfo).getChangeLsn().toString()), (Object)"begin_lsn", ((SourceInfo)this.sourceInfo).getBeginLsn() == null ? null : ((SourceInfo)this.sourceInfo).getBeginLsn().toString())));
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public TxLogPosition getChangePosition() {
        return TxLogPosition.valueOf(((SourceInfo)this.sourceInfo).getCommitLsn(), ((SourceInfo)this.sourceInfo).getChangeLsn(), ((SourceInfo)this.sourceInfo).getTxId(), ((SourceInfo)this.sourceInfo).getBeginLsn());
    }

    public void setChangePosition(TxLogPosition position) {
        ((SourceInfo)this.sourceInfo).setCommitLsn(position.getCommitLsn());
        ((SourceInfo)this.sourceInfo).setChangeLsn(position.getChangeLsn());
        ((SourceInfo)this.sourceInfo).setTxId(position.getTxId());
        ((SourceInfo)this.sourceInfo).setBeginLsn(position.getBeginLsn());
    }

    public boolean isSnapshotRunning() {
        return ((SourceInfo)this.sourceInfo).isSnapshot() && !this.snapshotCompleted;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        ((SourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).setTimestamp(timestamp);
        ((SourceInfo)this.sourceInfo).setTableId((TableId)tableId);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public String toString() {
        return "InformixOffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", snapshotCompleted=" + this.snapshotCompleted + "]";
    }

    public static class Loader
    implements OffsetContext.Loader<InformixOffsetContext> {
        private final InformixConnectorConfig connectorConfig;

        public Loader(InformixConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public InformixOffsetContext load(Map<String, ?> offset) {
            Lsn commitLsn = Lsn.of((String)offset.get("commit_lsn"));
            Lsn changeLsn = Lsn.of((String)offset.get("change_lsn"));
            Lsn beginLsn = Lsn.of((String)offset.get("begin_lsn"));
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(InformixOffsetContext.SNAPSHOT_COMPLETED_KEY));
            return new InformixOffsetContext(this.connectorConfig, TxLogPosition.valueOf(commitLsn, changeLsn, beginLsn), snapshot, snapshotCompleted, TransactionContext.load(offset), (IncrementalSnapshotContext<TableId>)SignalBasedIncrementalSnapshotContext.load(offset, (boolean)false));
        }
    }
}

