/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.informix.InformixChangeEventSourceFactory;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.InformixDatabaseSchema;
import io.debezium.connector.informix.InformixEventMetadataProvider;
import io.debezium.connector.informix.InformixOffsetContext;
import io.debezium.connector.informix.InformixPartition;
import io.debezium.connector.informix.InformixSchemaFactory;
import io.debezium.connector.informix.InformixTaskContext;
import io.debezium.connector.informix.InformixTransactionMonitor;
import io.debezium.connector.informix.InformixValueConverters;
import io.debezium.connector.informix.Module;
import io.debezium.document.DocumentReader;
import io.debezium.function.BlockingConsumer;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.Sizeable;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformixConnectorTask
extends BaseSourceTask<InformixPartition, InformixOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformixConnectorTask.class);
    private static final String CONTEXT_NAME = "informix-server-connector-task";
    private volatile InformixTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile InformixConnection dataConnection;
    private volatile InformixConnection cdcConnection;
    private volatile ErrorHandler errorHandler;
    private volatile InformixDatabaseSchema schema;

    public String version() {
        return Module.version();
    }

    protected ChangeEventSourceCoordinator<InformixPartition, InformixOffsetContext> start(Configuration config) {
        InformixConnectorConfig connectorConfig = new InformixConnectorConfig(config);
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        DefaultMainConnectionProvidingConnectionFactory connectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> new InformixConnection(connectorConfig.getJdbcConfig()));
        DefaultMainConnectionProvidingConnectionFactory cdcConnectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> new InformixConnection(connectorConfig.getCdcJdbcConfig()));
        this.dataConnection = (InformixConnection)connectionFactory.mainConnection();
        this.cdcConnection = (InformixConnection)cdcConnectionFactory.mainConnection();
        try {
            this.dataConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
        InformixValueConverters valueConverters = new InformixValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode(), connectorConfig.binaryHandlingMode());
        this.schema = new InformixDatabaseSchema(connectorConfig, (TopicNamingStrategy<TableId>)topicNamingStrategy, valueConverters, schemaNameAdjuster, this.dataConnection);
        this.schema.initializeStorage();
        Offsets previousOffsets = this.getPreviousOffsets(new InformixPartition.Provider(connectorConfig), new InformixOffsetContext.Loader(connectorConfig));
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)connectionFactory.newConnection());
        connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverters);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)previousOffsets);
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        InformixPartition partition = (InformixPartition)previousOffsets.getTheOnlyPartition();
        InformixOffsetContext previousOffset = (InformixOffsetContext)previousOffsets.getTheOnlyOffset();
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        this.validateAndLoadSchemaHistory((CommonConnectorConfig)connectorConfig, this.dataConnection, previousOffsets, (DatabaseSchema)this.schema, snapshotterService.getSnapshotter());
        this.taskContext = new InformixTaskContext(connectorConfig, this.schema);
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new ErrorHandler(InformixConnector.class, (CommonConnectorConfig)connectorConfig, this.queue, this.errorHandler);
        InformixEventMetadataProvider metadataProvider = new InformixEventMetadataProvider();
        SignalProcessor signalProcessor = new SignalProcessor(InformixConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, null, connectorConfig.createHeartbeat(topicNamingStrategy, schemaNameAdjuster, null, null), schemaNameAdjuster, (TransactionMonitor)new InformixTransactionMonitor((CommonConnectorConfig)connectorConfig, metadataProvider, schemaNameAdjuster, (BlockingConsumer<SourceRecord>)((BlockingConsumer)record -> this.queue.enqueue((Sizeable)new DataChangeEvent(record))), topicNamingStrategy.transactionTopic()), signalProcessor);
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, (SchemaFactory)InformixSchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, InformixConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new InformixChangeEventSourceFactory(connectorConfig, (MainConnectionProvidingConnectionFactory<InformixConnection>)connectionFactory, (MainConnectionProvidingConnectionFactory<InformixConnection>)cdcConnectionFactory, this.errorHandler, (EventDispatcher<InformixPartition, TableId>)dispatcher, clock, this.schema, snapshotterService), (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    protected List<SourceRecord> doPoll() throws InterruptedException {
        return this.queue.poll().stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    protected void doStop() {
        block9: {
            try {
                if (this.dataConnection == null) break block9;
                if (this.dataConnection.isConnected()) {
                    try {
                        this.dataConnection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.dataConnection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
            }
        }
        try {
            if (this.cdcConnection != null) {
                this.cdcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing CDC JDBC connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return InformixConnectorConfig.ALL_FIELDS;
    }
}

