/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.InformixDatabaseSchema;
import io.debezium.connector.informix.InformixOffsetContext;
import io.debezium.connector.informix.InformixPartition;
import io.debezium.connector.informix.TxLogPosition;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.SnapshottingTask;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformixSnapshotChangeEventSource
extends RelationalSnapshotChangeEventSource<InformixPartition, InformixOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformixSnapshotChangeEventSource.class);
    private final InformixConnectorConfig connectorConfig;
    private final InformixConnection jdbcConnection;

    public InformixSnapshotChangeEventSource(InformixConnectorConfig connectorConfig, MainConnectionProvidingConnectionFactory<InformixConnection> connectionFactory, InformixDatabaseSchema schema, EventDispatcher<InformixPartition, TableId> dispatcher, Clock clock, SnapshotProgressListener<InformixPartition> snapshotProgressListener, NotificationService<InformixPartition, InformixOffsetContext> notificationService, SnapshotterService snapshotterService) {
        super((RelationalDatabaseConnectorConfig)connectorConfig, connectionFactory, (RelationalDatabaseSchema)schema, dispatcher, clock, snapshotProgressListener, notificationService, snapshotterService);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = (InformixConnection)connectionFactory.mainConnection();
    }

    public SnapshottingTask getSnapshottingTask(InformixPartition partition, InformixOffsetContext previousOffset) {
        boolean snapshotData;
        boolean snapshotSchema = true;
        List dataCollectionsToBeSnapshotted = this.connectorConfig.getDataCollectionsToBeSnapshotted();
        Map<String, String> snapshotSelectOverridesByTable = this.connectorConfig.getSnapshotSelectOverridesByTable().entrySet().stream().collect(Collectors.toMap(e -> ((DataCollectionId)e.getKey()).identifier(), Map.Entry::getValue));
        if (previousOffset != null && !previousOffset.isSnapshotRunning()) {
            LOGGER.info("A previous offset indicating a completed snapshot has been found. Neither schema nor data will be snapshot.");
            snapshotSchema = false;
            snapshotData = false;
        } else {
            LOGGER.info("No previous offset has been found");
            if (this.connectorConfig.getSnapshotMode().includeData()) {
                LOGGER.info("According to the connector configuration both schema and data will be snapshot");
            } else {
                LOGGER.info("According to the connector configuration only schema will be snapshot");
            }
            snapshotData = this.connectorConfig.getSnapshotMode().includeData();
        }
        return new SnapshottingTask(snapshotSchema, snapshotData, dataCollectionsToBeSnapshotted, snapshotSelectOverridesByTable, false);
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext<InformixPartition, InformixOffsetContext> prepare(InformixPartition partition, boolean onDemand) {
        return new InformixSnapshotContext(partition, this.jdbcConnection.getRealDatabaseName(), onDemand);
    }

    protected void connectionCreated(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) throws Exception {
        ((InformixSnapshotContext)snapshotContext).isolationLevelBeforeStart = this.jdbcConnection.connection().getTransactionIsolation();
    }

    protected Set<TableId> getAllTableIds(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> ctx) throws Exception {
        return this.jdbcConnection.readAllTableNames(new String[]{"TABLE"});
    }

    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotIsolationMode() == InformixConnectorConfig.SnapshotIsolationMode.READ_UNCOMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(1);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == InformixConnectorConfig.SnapshotIsolationMode.READ_COMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(2);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == InformixConnectorConfig.SnapshotIsolationMode.EXCLUSIVE || this.connectorConfig.getSnapshotIsolationMode() == InformixConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().setTransactionIsolation(4);
            ((InformixSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("informix_schema_snapshot");
            LOGGER.info("Executing schema locking");
            try (Statement statement = this.jdbcConnection.connection().createStatement(1003, 1007);){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + tableId);
                    }
                    LOGGER.info("Locking table {}", (Object)tableId);
                    String query = String.format("LOCK TABLE %s.%s IN %s MODE", tableId.schema(), tableId.table(), this.connectorConfig.getSnapshotIsolationMode().equals((Object)InformixConnectorConfig.SnapshotIsolationMode.EXCLUSIVE) ? "EXCLUSIVE" : "SHARE");
                    statement.execute(query);
                }
            }
        } else {
            throw new IllegalStateException("Unknown locking mode specified.");
        }
    }

    protected void releaseSchemaSnapshotLocks(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotIsolationMode() == InformixConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().rollback(((InformixSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
            LOGGER.info("Schema locks released.");
        }
    }

    protected void determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> ctx, InformixOffsetContext previousOffset) throws SQLException {
        InformixOffsetContext offset = (InformixOffsetContext)ctx.offset;
        if (offset == null) {
            offset = previousOffset != null ? previousOffset : new InformixOffsetContext(this.connectorConfig, TxLogPosition.valueOf(this.jdbcConnection.getMaxLsn()), false, false);
            ctx.offset = offset;
        }
    }

    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext, InformixOffsetContext offsetContext, SnapshottingTask snapshottingTask) throws SQLException, InterruptedException {
        Set schemas = this.getTablesForSchemaChange(snapshotContext).stream().map(TableId::schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            LOGGER.info("Reading structure of schema '{}'", (Object)schema);
            Tables.TableFilter tableFilter = null;
            if (snapshottingTask.isOnDemand()) {
                tableFilter = Tables.TableFilter.fromPredicate(snapshotContext.capturedTables::contains);
            } else if (this.connectorConfig.storeOnlyCapturedTables()) {
                tableFilter = this.connectorConfig.getTableFilters().dataCollectionFilter();
            }
            this.jdbcConnection.readSchema(snapshotContext.tables, null, schema, tableFilter, null, false);
        }
    }

    protected Collection<TableId> getTablesForSchemaChange(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) {
        return this.connectorConfig.storeOnlyCapturedTables() ? snapshotContext.capturedTables : snapshotContext.capturedSchemaTables;
    }

    protected SchemaChangeEvent getCreateTableEvent(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext, Table table) {
        return SchemaChangeEvent.ofSnapshotCreate((Partition)snapshotContext.partition, (OffsetContext)snapshotContext.offset, (String)snapshotContext.catalogName, (Table)table);
    }

    protected void completed(AbstractSnapshotChangeEventSource.SnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) {
        this.close(snapshotContext);
    }

    protected void aborted(AbstractSnapshotChangeEventSource.SnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) {
        this.close(snapshotContext);
    }

    private void close(AbstractSnapshotChangeEventSource.SnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) {
        try {
            this.jdbcConnection.connection().setTransactionIsolation(((InformixSnapshotContext)snapshotContext).isolationLevelBeforeStart);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set transaction isolation level.", e);
        }
    }

    protected Optional<String> getSnapshotSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext, TableId tableId, List<String> columns) {
        String snapshotSelectColumns = !columns.isEmpty() ? Strings.join((CharSequence)", ", columns) : "*";
        return Optional.of(String.format("SELECT %s FROM %s.%s", snapshotSelectColumns, tableId.schema(), tableId.table()));
    }

    protected InformixOffsetContext copyOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> snapshotContext) {
        return new InformixOffsetContext.Loader(this.connectorConfig).load(((InformixOffsetContext)snapshotContext.offset).getOffset());
    }

    protected ResultSet resultSetForDataEvents(String selectStatement, Statement statement) throws SQLException {
        return statement.executeQuery(selectStatement);
    }

    private static class InformixSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<InformixPartition, InformixOffsetContext> {
        private int isolationLevelBeforeStart;
        private Savepoint preSchemaSnapshotSavepoint;

        InformixSnapshotContext(InformixPartition partition, String catalogName, boolean onDemand) {
            super((Partition)partition, catalogName, onDemand);
        }
    }
}

