/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.pipeline.notification.AbstractNotificationsIT;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;

public class NotificationsIT
extends AbstractNotificationsIT<InformixConnector> {
    private InformixConnection connection;

    @Before
    public void before() {
        this.connection = TestHelper.testConnection();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback().close();
        }
    }

    protected Class<InformixConnector> connectorClass() {
        return InformixConnector.class;
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL);
    }

    protected String connector() {
        return "informix_server";
    }

    protected String server() {
        return "testdb";
    }

    protected String snapshotStatusResult() {
        return "COMPLETED";
    }
}

