/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.informix.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class InformixSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private Schema schema;

    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        super.init(connector, version, connectorConfig);
        this.schema = this.commonSchemaBuilder().name("io.debezium.connector.informix.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("commit_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("change_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("begin_lsn", Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        Struct ret = super.commonStruct((AbstractSourceInfo)sourceInfo);
        if (sourceInfo.getTableId() != null) {
            ret.put("schema", (Object)sourceInfo.getTableId().schema()).put("table", (Object)sourceInfo.getTableId().table());
        }
        if (sourceInfo.getCommitLsn() != null && sourceInfo.getCommitLsn().isAvailable()) {
            ret.put("commit_lsn", (Object)sourceInfo.getCommitLsn().toString());
        }
        if (sourceInfo.getChangeLsn() != null && sourceInfo.getChangeLsn().isAvailable()) {
            ret.put("change_lsn", (Object)sourceInfo.getChangeLsn().toString());
        }
        if (sourceInfo.getTxId() >= 0) {
            ret.put("txId", (Object)sourceInfo.getTxId().toString());
        }
        if (sourceInfo.getBeginLsn() != null && sourceInfo.getBeginLsn().isAvailable()) {
            ret.put("begin_lsn", (Object)sourceInfo.getBeginLsn().toString());
        }
        return ret;
    }
}

