/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.InformixDatabaseSchema;
import io.debezium.connector.informix.InformixOffsetContext;
import io.debezium.connector.informix.InformixPartition;
import io.debezium.connector.informix.InformixSnapshotChangeEventSource;
import io.debezium.connector.informix.InformixStreamingChangeEventSource;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.util.Optional;

public class InformixChangeEventSourceFactory
implements ChangeEventSourceFactory<InformixPartition, InformixOffsetContext> {
    private final InformixConnectorConfig configuration;
    private final MainConnectionProvidingConnectionFactory<InformixConnection> connectionFactory;
    private final MainConnectionProvidingConnectionFactory<InformixConnection> cdcConnectionFactory;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<InformixPartition, TableId> dispatcher;
    private final Clock clock;
    private final InformixDatabaseSchema schema;
    private final SnapshotterService snapshotterService;

    public InformixChangeEventSourceFactory(InformixConnectorConfig configuration, MainConnectionProvidingConnectionFactory<InformixConnection> connectionFactory, MainConnectionProvidingConnectionFactory<InformixConnection> cdcConnectionFactory, ErrorHandler errorHandler, EventDispatcher<InformixPartition, TableId> dispatcher, Clock clock, InformixDatabaseSchema schema, SnapshotterService snapshotterService) {
        this.configuration = configuration;
        this.connectionFactory = connectionFactory;
        this.cdcConnectionFactory = cdcConnectionFactory;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.snapshotterService = snapshotterService;
    }

    public SnapshotChangeEventSource<InformixPartition, InformixOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<InformixPartition> snapshotProgressListener, NotificationService<InformixPartition, InformixOffsetContext> notificationService) {
        return new InformixSnapshotChangeEventSource(this.configuration, this.connectionFactory, this.schema, this.dispatcher, this.clock, snapshotProgressListener, notificationService, this.snapshotterService);
    }

    public StreamingChangeEventSource<InformixPartition, InformixOffsetContext> getStreamingChangeEventSource() {
        return new InformixStreamingChangeEventSource(this.configuration, (InformixConnection)this.cdcConnectionFactory.mainConnection(), (InformixConnection)this.cdcConnectionFactory.newConnection(), this.dispatcher, this.errorHandler, this.clock, this.schema);
    }

    public Optional<IncrementalSnapshotChangeEventSource<InformixPartition, ? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(InformixOffsetContext offsetContext, SnapshotProgressListener<InformixPartition> snapshotProgressListener, DataChangeEventListener<InformixPartition> dataChangeEventListener, NotificationService<InformixPartition, InformixOffsetContext> notificationService) {
        return Optional.ofNullable(this.configuration.getSignalingDataCollectionId()).map(s -> new SignalBasedIncrementalSnapshotChangeEventSource((RelationalDatabaseConnectorConfig)this.configuration, this.connectionFactory.mainConnection(), this.dispatcher, (DatabaseSchema)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener, notificationService));
    }
}

