/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SchemaHistoryTopicIT
extends AbstractConnectorTest {
    private InformixConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS tablea", "DROP TABLE IF EXISTS tableb", "DROP TABLE IF EXISTS tablec", "CREATE TABLE tablea (id int not null, cola varchar(30), primary key(id))", "CREATE TABLE tableb (id int not null, colb varchar(30), primary key(id))", "CREATE TABLE tablec (id int not null, colc varchar(30), primary key(id))"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        SchemaHistoryTopicIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{"DROP TABLE tablea", "DROP TABLE tableb", "DROP TABLE tablec"}).close();
        }
    }

    @Test
    @FixFor(value={"DBZ-1904"})
    public void snapshotSchemaChanges() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).with(InformixConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        SchemaHistoryTopicIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        SchemaHistoryTopicIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.waitForAvailableRecords(10L, TimeUnit.SECONDS);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List schemaRecords = records.allRecordsInOrder();
        Assertions.assertThat((List)schemaRecords).hasSize(3);
        schemaRecords.forEach(record -> {
            Assertions.assertThat((String)record.topic()).isEqualTo((Object)"testdb");
            Assertions.assertThat((String)((Struct)record.key()).getString("databaseName")).isEqualTo((Object)"testdb");
            Assertions.assertThat(record.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        });
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(1)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(2)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        List tableCanges = ((Struct)((SourceRecord)schemaRecords.get(0)).value()).getArray("tableChanges");
        Assertions.assertThat((List)tableCanges).hasSize(1);
        Assertions.assertThat((Object)((Struct)tableCanges.get(0)).get("type")).isEqualTo((Object)"CREATE");
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("testdb.informix.tablea")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("testdb.informix.tableb")).hasSize(5);
        records.recordsForTopic("testdb.informix.tableb").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("testdb.informix.tableb.Value").field("id", Schema.INT32_SCHEMA).field("colb", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }
}

