/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.converters.CloudEventsConverterTest;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InformixConnectorIT
extends AbstractConnectorTest {
    private InformixConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS tablea", "DROP TABLE IF EXISTS tableb", "DROP TABLE IF EXISTS masked_hashed_column_table", "DROP TABLE IF EXISTS truncated_column_table", "DROP TABLE IF EXISTS truncate_table", "DROP TABLE IF EXISTS dt_table", "CREATE TABLE tablea (id int not null, cola varchar(30), primary key (id))", "CREATE TABLE tableb (id int not null, colb varchar(30), primary key (id))", "CREATE TABLE masked_hashed_column_table (id int not null, name varchar(255), name2 varchar(255), name3 varchar(20), primary key (id))", "CREATE TABLE truncated_column_table (id int not null, name varchar(20), primary key (id))", "CREATE TABLE truncate_table (id int not null, name varchar(20), primary key (id))", "CREATE TABLE dt_table (id int not null, c1 int, c2 int, c3a numeric(5,2), c3b varchar(128), f1 float(14), f2 decimal(8,4), primary key(id))"}).execute(new String[]{"INSERT INTO tablea VALUES(1, 'a')"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        InformixConnectorIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{"DROP TABLE tablea", "DROP TABLE tableb", "DROP TABLE masked_hashed_column_table", "DROP TABLE truncated_column_table", "DROP TABLE truncate_table", "DROP TABLE dt_table"}).close();
        }
    }

    @Test
    public void deleteWithoutTombstone() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(InformixConnectorConfig.TOMBSTONES_ON_DELETE, false)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.consumeRecordsByTopic(10);
        this.connection.execute(new String[]{"DELETE FROM tableB"});
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(5);
        List deleteTableA = deleteRecords.recordsForTopic("testdb.informix.tablea");
        List deleteTableB = deleteRecords.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)deleteTableA).isNullOrEmpty();
        Assertions.assertThat((List)deleteTableB).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            SourceRecord deleteRecord = (SourceRecord)deleteTableB.get(i);
            VerifyRecord.isValidDelete((SourceRecord)deleteRecord, (boolean)true);
            List<SchemaAndValueField> expectedValueBefore = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i + 10)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct deleteValue = (Struct)deleteRecord.value();
            this.assertRecord((Struct)deleteValue.get("before"), expectedValueBefore);
        }
    }

    @Test
    public void deleteWithTombstone() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 20;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).with(InformixConnectorConfig.TOMBSTONES_ON_DELETE, true)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecordsByTopic(1);
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        for (int i = 0; i < 5; ++i) {
            int id = 20 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.consumeRecordsByTopic(10);
        this.connection.execute(new String[]{"DELETE FROM tableB"});
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(10);
        List deleteTableA = deleteRecords.recordsForTopic("testdb.informix.tablea");
        List deleteTableB = deleteRecords.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)deleteTableA).isNullOrEmpty();
        Assertions.assertThat((List)deleteTableB).hasSize(10);
        for (int i = 0; i < 10; ++i) {
            SourceRecord deleteRecord = (SourceRecord)deleteTableB.get(i);
            if (deleteRecord.value() == null) {
                VerifyRecord.isValidTombstone((SourceRecord)deleteRecord);
                continue;
            }
            VerifyRecord.isValidDelete((SourceRecord)deleteRecord, (boolean)true);
            List<SchemaAndValueField> expectedValueBefore = Arrays.asList(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)(i / 2 + 20)), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct deleteValue = (Struct)deleteRecord.value();
            this.assertRecord((Struct)deleteValue.get("before"), expectedValueBefore);
        }
    }

    @Test
    public void testTruncateTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START = 30;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(CommonConnectorConfig.SKIPPED_OPERATIONS, "none")).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        for (int i = 0; i < 5; ++i) {
            int id = 30 + i;
            this.connection.execute(new String[]{"INSERT INTO truncate_table VALUES(" + id + ", 'name')"});
        }
        this.consumeRecordsByTopic(5);
        this.connection.execute(new String[]{"truncate table truncate_table"});
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(1);
        List truncateTable = sourceRecords.recordsForTopic("testdb.informix.truncate_table");
        ((ListAssert)Assertions.assertThat((List)truncateTable).isNotNull()).hasSize(1);
        VerifyRecord.isValidTruncate((SourceRecord)((SourceRecord)truncateTable.get(0)));
    }

    @Test
    public void updatePrimaryKey() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecordsByTopic(1);
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(1, 'b')"});
        this.consumeRecordsByTopic(1);
        this.connection.execute(new String[]{"UPDATE tablea SET id=100 WHERE id=1", "UPDATE tableb SET id=100 WHERE id=1"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        List tableA = records.recordsForTopic("testdb.informix.tablea");
        List tableB = records.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)tableA).hasSize(3);
        Assertions.assertThat((List)tableB).hasSize(3);
        List<SchemaAndValueField> expectedDeleteRowA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
        List<SchemaAndValueField> expectedDeleteKeyA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1));
        List<SchemaAndValueField> expectedInsertRowA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
        List<SchemaAndValueField> expectedInsertKeyA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100));
        SourceRecord deleteRecordA = (SourceRecord)tableA.get(0);
        SourceRecord tombstoneRecordA = (SourceRecord)tableA.get(1);
        SourceRecord insertRecordA = (SourceRecord)tableA.get(2);
        Struct deleteKeyA = (Struct)deleteRecordA.key();
        Struct deleteValueA = (Struct)deleteRecordA.value();
        this.assertRecord(deleteValueA.getStruct("before"), expectedDeleteRowA);
        this.assertRecord(deleteKeyA, expectedDeleteKeyA);
        Assert.assertNull((Object)deleteValueA.get("after"));
        Struct tombstoneKeyA = (Struct)tombstoneRecordA.key();
        Struct tombstoneValueA = (Struct)tombstoneRecordA.value();
        this.assertRecord(tombstoneKeyA, expectedDeleteKeyA);
        Assert.assertNull((Object)tombstoneValueA);
        Struct insertKeyA = (Struct)insertRecordA.key();
        Struct insertValueA = (Struct)insertRecordA.value();
        this.assertRecord(insertValueA.getStruct("after"), expectedInsertRowA);
        this.assertRecord(insertKeyA, expectedInsertKeyA);
        Assert.assertNull((Object)insertValueA.get("before"));
        List<SchemaAndValueField> expectedDeleteRowB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
        List<SchemaAndValueField> expectedDeleteKeyB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1));
        List<SchemaAndValueField> expectedInsertRowB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
        List<SchemaAndValueField> expectedInsertKeyB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100));
        SourceRecord deleteRecordB = (SourceRecord)tableB.get(0);
        SourceRecord tombstoneRecordB = (SourceRecord)tableB.get(1);
        SourceRecord insertRecordB = (SourceRecord)tableB.get(2);
        Struct deletekeyB = (Struct)deleteRecordB.key();
        Struct deleteValueB = (Struct)deleteRecordB.value();
        this.assertRecord(deleteValueB.getStruct("before"), expectedDeleteRowB);
        this.assertRecord(deletekeyB, expectedDeleteKeyB);
        Assert.assertNull((Object)deleteValueB.get("after"));
        Struct tombstonekeyB = (Struct)tombstoneRecordB.key();
        Struct tombstoneValueB = (Struct)tombstoneRecordB.value();
        this.assertRecord(tombstonekeyB, expectedDeleteKeyB);
        Assert.assertNull((Object)tombstoneValueB);
        Struct insertkeyB = (Struct)insertRecordB.key();
        Struct insertValueB = (Struct)insertRecordB.value();
        this.assertRecord(insertValueB.getStruct("after"), expectedInsertRowB);
        this.assertRecord(insertkeyB, expectedInsertKeyB);
        Assert.assertNull((Object)insertValueB.get("before"));
    }

    @Test
    @FixFor(value={"DBZ-1152"})
    public void updatePrimaryKeyWithRestartInMiddle() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecordsByTopic(1);
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(1, 'b')"});
        this.consumeRecordsByTopic(1);
        this.connection.execute(new String[]{"UPDATE tablea SET id=100 WHERE id=1", "UPDATE tableb SET id=100 WHERE id=1"});
        AbstractConnectorTest.SourceRecords records1 = this.consumeRecordsByTopic(2);
        this.stopConnector();
        this.assertConnectorNotRunning();
        InformixConnectorIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(4);
        List tableA = records1.recordsForTopic("testdb.informix.tablea");
        tableA.addAll(records2.recordsForTopic("testdb.informix.tablea"));
        List tableB = records2.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)tableA).hasSize(3);
        Assertions.assertThat((List)tableB).hasSize(3);
        List<SchemaAndValueField> expectedDeleteRowA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
        List<SchemaAndValueField> expectedDeleteKeyA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1));
        List<SchemaAndValueField> expectedInsertRowA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
        List<SchemaAndValueField> expectedInsertKeyA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100));
        SourceRecord deleteRecordA = (SourceRecord)tableA.get(0);
        SourceRecord tombstoneRecordA = (SourceRecord)tableA.get(1);
        SourceRecord insertRecordA = (SourceRecord)tableA.get(2);
        Struct deleteKeyA = (Struct)deleteRecordA.key();
        Struct deleteValueA = (Struct)deleteRecordA.value();
        this.assertRecord(deleteValueA.getStruct("before"), expectedDeleteRowA);
        this.assertRecord(deleteKeyA, expectedDeleteKeyA);
        Assert.assertNull((Object)deleteValueA.get("after"));
        Struct tombstoneKeyA = (Struct)tombstoneRecordA.key();
        Struct tombstoneValueA = (Struct)tombstoneRecordA.value();
        this.assertRecord(tombstoneKeyA, expectedDeleteKeyA);
        Assert.assertNull((Object)tombstoneValueA);
        Struct insertKeyA = (Struct)insertRecordA.key();
        Struct insertValueA = (Struct)insertRecordA.value();
        this.assertRecord(insertValueA.getStruct("after"), expectedInsertRowA);
        this.assertRecord(insertKeyA, expectedInsertKeyA);
        Assert.assertNull((Object)insertValueA.get("before"));
        List<SchemaAndValueField> expectedDeleteRowB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
        List<SchemaAndValueField> expectedDeleteKeyB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)1));
        List<SchemaAndValueField> expectedInsertRowB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
        List<SchemaAndValueField> expectedInsertKeyB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)100));
        SourceRecord deleteRecordB = (SourceRecord)tableB.get(0);
        SourceRecord tombstoneRecordB = (SourceRecord)tableB.get(1);
        SourceRecord insertRecordB = (SourceRecord)tableB.get(2);
        Struct deletekeyB = (Struct)deleteRecordB.key();
        Struct deleteValueB = (Struct)deleteRecordB.value();
        this.assertRecord(deleteValueB.getStruct("before"), expectedDeleteRowB);
        this.assertRecord(deletekeyB, expectedDeleteKeyB);
        Assert.assertNull((Object)deleteValueB.get("after"));
        Struct tombstonekeyB = (Struct)tombstoneRecordB.key();
        Struct tombstoneValueB = (Struct)tombstoneRecordB.value();
        this.assertRecord(tombstonekeyB, expectedDeleteKeyB);
        Assert.assertNull((Object)tombstoneValueB);
        Struct insertkeyB = (Struct)insertRecordB.key();
        Struct insertValueB = (Struct)insertRecordB.value();
        this.assertRecord(insertValueB.getStruct("after"), expectedInsertRowB);
        this.assertRecord(insertkeyB, expectedInsertKeyB);
        Assert.assertNull((Object)insertValueB.get("before"));
    }

    @Test
    @FixFor(value={"DBZ-1069"})
    public void verifyOffsets() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START = 40;
        int ID_RESTART = 100;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).build();
        for (int i = 0; i < 5; ++i) {
            int id = 40 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        List records = this.consumeRecordsByTopic(11).allRecordsInOrder();
        records = records.subList(1, records.size());
        Iterator it = records.iterator();
        while (it.hasNext()) {
            SourceRecord record = (SourceRecord)it.next();
            ((ObjectAssert)Assertions.assertThat(record.sourceOffset().get("snapshot")).as("Snapshot phase", new Object[0])).isEqualTo((Object)true);
            if (it.hasNext()) {
                ((ObjectAssert)Assertions.assertThat(record.sourceOffset().get("snapshot_completed")).as("Snapshot in progress", new Object[0])).isEqualTo((Object)false);
                continue;
            }
            ((ObjectAssert)Assertions.assertThat(record.sourceOffset().get("snapshot_completed")).as("Snapshot completed", new Object[0])).isEqualTo((Object)true);
        }
        this.stopConnector();
        this.assertConnectorNotRunning();
        InformixConnectorIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        for (int i = 0; i < 5; ++i) {
            int id = 100 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(-1, 'b')"});
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(10);
        List tableA = sourceRecords.recordsForTopic("testdb.informix.tablea");
        List tableB = sourceRecords.recordsForTopic("testdb.informix.tableb");
        this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(5);
        for (int i = 0; i < 5; ++i) {
            int id = i + 100;
            SourceRecord recordA = (SourceRecord)tableA.get(i);
            SourceRecord recordB = (SourceRecord)tableB.get(i);
            List<SchemaAndValueField> expectedRowA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            List<SchemaAndValueField> expectedRowB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            Struct valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            Struct valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
            ((ObjectAssert)Assertions.assertThat(recordA.sourceOffset().get("snapshot")).as("Streaming phase", new Object[0])).isNull();
            ((ObjectAssert)Assertions.assertThat(recordA.sourceOffset().get("snapshot_completed")).as("Streaming phase", new Object[0])).isNull();
            ((ObjectAssert)Assertions.assertThat(recordA.sourceOffset().get("change_lsn")).as("LSN present", new Object[0])).isNotNull();
            ((ObjectAssert)Assertions.assertThat(recordB.sourceOffset().get("snapshot")).as("Streaming phase", new Object[0])).isNull();
            ((ObjectAssert)Assertions.assertThat(recordB.sourceOffset().get("snapshot_completed")).as("Streaming phase", new Object[0])).isNull();
            ((ObjectAssert)Assertions.assertThat(recordB.sourceOffset().get("change_lsn")).as("LSN present", new Object[0])).isNotNull();
        }
    }

    @Test
    public void testTableIncludeList() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START = 50;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(InformixConnectorConfig.TABLE_INCLUDE_LIST, "testdb.informix.tableb")).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        for (int i = 0; i < 5; ++i) {
            int id = 50 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableA = records.recordsForTopic("testdb.informix.tablea");
        List tableB = records.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)tableA).isNullOrEmpty();
        Assertions.assertThat((List)tableB).hasSize(5);
    }

    @Test
    public void testTableExcludeList() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START = 60;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).with(InformixConnectorConfig.TABLE_EXCLUDE_LIST, "testdb.informix.tablea")).build();
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(1, 'b')"});
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecordsByTopic(1);
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        for (int i = 0; i < 5; ++i) {
            int id = 60 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableA = records.recordsForTopic("testdb.informix.tablea");
        List tableB = records.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)tableA).isNullOrEmpty();
        Assertions.assertThat((List)tableB).hasSize(5);
    }

    private void restartInTheMiddleOfTx(boolean restartJustAfterSnapshot, boolean afterStreaming) throws Exception {
        Struct valueB;
        Struct valueA;
        List<SchemaAndValueField> expectedRowB;
        List<SchemaAndValueField> expectedRowA;
        SourceRecord recordB;
        SourceRecord recordA;
        int id;
        int i;
        int RECORDS_PER_TABLE = 30;
        int TABLES = 2;
        int ID_START = 200;
        int ID_RESTART = 1000;
        int HALF_ID = 215;
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).build();
        if (restartJustAfterSnapshot) {
            this.start(InformixConnector.class, config);
            this.assertConnectorIsRunning();
            InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
            this.consumeRecordsByTopic(1);
            this.stopConnector();
            this.assertConnectorNotRunning();
            InformixConnectorIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(-1, '-a')"});
        }
        this.start(InformixConnector.class, config, record -> {
            if (!"testdb.informix.tablea.Envelope".equals(record.valueSchema().name())) {
                return false;
            }
            Struct envelope = (Struct)record.value();
            Struct after = envelope.getStruct("after");
            Integer id = after.getInt32("id");
            String value = after.getString("cola");
            return id != null && id == 215 && "a".equals(value);
        });
        this.assertConnectorIsRunning();
        if (restartJustAfterSnapshot) {
            InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
            this.consumeRecordsByTopic(1);
        } else {
            InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        }
        this.consumeRecordsByTopic(1);
        if (afterStreaming) {
            InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(-2, '-a')"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List<SchemaAndValueField> expectedRow = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)-2), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"-a"));
            this.assertRecord(((Struct)((SourceRecord)records.allRecordsInOrder().get(0)).value()).getStruct("after"), expectedRow);
        }
        this.connection.setAutoCommit(false);
        for (int i2 = 0; i2 < 30; ++i2) {
            int id2 = 200 + i2;
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO tablea VALUES(" + id2 + ", 'a')"});
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO tableb VALUES(" + id2 + ", 'b')"});
        }
        this.connection.commit();
        this.waitForAvailableRecords(5L, TimeUnit.SECONDS);
        List records = this.consumeRecordsByTopic(30).allRecordsInOrder();
        Assertions.assertThat((List)records).hasSize(30);
        SourceRecord lastRecordForOffset = (SourceRecord)records.get(29);
        Struct value = (Struct)lastRecordForOffset.value();
        List<SchemaAndValueField> expectedLastRow = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)214), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
        this.assertRecord((Struct)value.get("after"), expectedLastRow);
        this.stopConnector();
        this.assertConnectorNotRunning();
        InformixConnectorIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.waitForAvailableRecords(5L, TimeUnit.SECONDS);
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(30);
        List tableA = sourceRecords.recordsForTopic("testdb.informix.tablea");
        List tableB = sourceRecords.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)tableA).hasSize(15);
        Assertions.assertThat((List)tableB).hasSize(15);
        for (i = 0; i < 15; ++i) {
            id = 215 + i;
            recordA = (SourceRecord)tableA.get(i);
            recordB = (SourceRecord)tableB.get(i);
            expectedRowA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            expectedRowB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
        for (i = 0; i < 30; ++i) {
            id = 1000 + i;
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
            this.connection.commit();
        }
        this.waitForAvailableRecords(5L, TimeUnit.SECONDS);
        sourceRecords = this.consumeRecordsByTopic(60);
        tableA = sourceRecords.recordsForTopic("testdb.informix.tablea");
        tableB = sourceRecords.recordsForTopic("testdb.informix.tableb");
        Assertions.assertThat((List)tableA).hasSize(30);
        Assertions.assertThat((List)tableB).hasSize(30);
        for (i = 0; i < 30; ++i) {
            id = i + 1000;
            recordA = (SourceRecord)tableA.get(i);
            recordB = (SourceRecord)tableB.get(i);
            expectedRowA = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("cola", Schema.OPTIONAL_STRING_SCHEMA, (Object)"a"));
            expectedRowB = List.of(new SchemaAndValueField("id", Schema.INT32_SCHEMA, (Object)id), new SchemaAndValueField("colb", Schema.OPTIONAL_STRING_SCHEMA, (Object)"b"));
            valueA = (Struct)recordA.value();
            this.assertRecord((Struct)valueA.get("after"), expectedRowA);
            Assert.assertNull((Object)valueA.get("before"));
            valueB = (Struct)recordB.value();
            this.assertRecord((Struct)valueB.get("after"), expectedRowB);
            Assert.assertNull((Object)valueB.get("before"));
        }
    }

    @Test
    @FixFor(value={"DBZ-1128"})
    public void restartInTheMiddleOfTxAfterSnapshot() throws Exception {
        this.restartInTheMiddleOfTx(true, false);
    }

    @Test
    @FixFor(value={"DBZ-1128"})
    public void restartInTheMiddleOfTxAfterCompletedTx() throws Exception {
        this.restartInTheMiddleOfTx(false, true);
    }

    @Test
    @FixFor(value={"DBZ-1128"})
    public void restartInTheMiddleOfTx() throws Exception {
        this.restartInTheMiddleOfTx(false, false);
    }

    @Test
    @FixFor(value={"DBZ-1242"})
    public void testEmptySchemaWarningAfterApplyingFilters() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor(RelationalDatabaseSchema.class);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).with(InformixConnectorConfig.TABLE_INCLUDE_LIST, "my_products")).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.stopConnector(value -> Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("After applying the include/exclude list filters, no changes will be captured. Please check your configuration!")).isTrue());
    }

    @Test
    @FixFor(value={"DBZ-775"})
    public void shouldConsumeEventsWithMaskedAndTruncatedColumns() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with("column.mask.with.12.chars", "testdb.informix.masked_hashed_column_table.name").with("column.mask.hash.SHA-256.with.salt.CzQMA0cB5K", "testdb.informix.masked_hashed_column_table.name2,testdb.informix.masked_hashed_column_table.name3").with("column.truncate.to.4.chars", "testdb.informix.truncated_column_table.name").build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        this.connection.execute(new String[]{"INSERT INTO masked_hashed_column_table (id, name, name2, name3) VALUES (10, 'some_name', 'test', 'test')"});
        this.connection.execute(new String[]{"INSERT INTO truncated_column_table VALUES(11, 'some_name')"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List tableA = records.recordsForTopic("testdb.informix.masked_hashed_column_table");
        List tableB = records.recordsForTopic("testdb.informix.truncated_column_table");
        Assertions.assertThat((List)tableA).hasSize(1);
        SourceRecord record = (SourceRecord)tableA.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"id", (int)10);
        Struct value = (Struct)record.value();
        if (value.getStruct("after") != null) {
            Struct after = value.getStruct("after");
            Assertions.assertThat((String)after.getString("name")).isEqualTo((Object)"************");
            Assertions.assertThat((String)after.getString("name2")).isEqualTo((Object)"8e68c68edbbac316dfe2f6ada6b0d2d3e2002b487a985d4b7c7c82dd83b0f4d7");
            Assertions.assertThat((String)after.getString("name3")).isEqualTo((Object)"8e68c68edbbac316dfe2");
        }
        Assertions.assertThat((List)tableB).hasSize(1);
        record = (SourceRecord)tableB.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"id", (int)11);
        value = (Struct)record.value();
        if (value.getStruct("after") != null) {
            Assertions.assertThat((String)value.getStruct("after").getString("name")).isEqualTo((Object)"some");
        }
    }

    @Test
    @FixFor(value={"DBZ-775"})
    public void shouldRewriteIdentityKey() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(InformixConnectorConfig.MSG_KEY_COLUMNS, "(.*).tablea:id,cola")).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        this.connection.execute(new String[]{"INSERT INTO tablea (id, cola) values (100, 'hundred')"});
        List records = this.consumeRecordsByTopic(1).recordsForTopic("testdb.informix.tablea");
        ((ListAssert)Assertions.assertThat((List)records).isNotNull()).isNotEmpty();
        Assertions.assertThat((Object)((SourceRecord)records.get(0)).key()).isNotNull();
        Struct key = (Struct)((SourceRecord)records.get(0)).key();
        Assertions.assertThat((Object)key.get("id")).isNotNull();
        Assertions.assertThat((Object)key.get("cola")).isNotNull();
    }

    @Test
    @FixFor(value={"DBZ-1916", "DBZ-1830"})
    public void shouldPropagateSourceTypeByDatatype() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with("datatype.propagate.source.type", ".+\\.NUMERIC,.+\\.VARCHAR,.+\\.DECIMAL,.+\\.FLOAT").build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        this.connection.execute(new String[]{"INSERT INTO dt_table (id,c1,c2,c3a,c3b,f1,f2) values (1,123,456,789.01,'test',1.228,234.56)"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List recordsForTopic = records.recordsForTopic("testdb.informix.dt_table");
        Assertions.assertThat((List)recordsForTopic).hasSize(1);
        Field before = ((SourceRecord)recordsForTopic.get(0)).valueSchema().field("before");
        Assertions.assertThat((Map)before.schema().field("id").schema().parameters()).isNull();
        Assertions.assertThat((Map)before.schema().field("c1").schema().parameters()).isNull();
        Assertions.assertThat((Map)before.schema().field("c2").schema().parameters()).isNull();
        Assertions.assertThat((Map)before.schema().field("c3a").schema().parameters()).contains(new Map.Entry[]{Assertions.entry((Object)"__debezium.source.column.type", (Object)"DECIMAL"), Assertions.entry((Object)"__debezium.source.column.length", (Object)"5"), Assertions.entry((Object)"__debezium.source.column.scale", (Object)"2")});
        Assertions.assertThat((Map)before.schema().field("c3b").schema().parameters()).contains(new Map.Entry[]{Assertions.entry((Object)"__debezium.source.column.type", (Object)"VARCHAR"), Assertions.entry((Object)"__debezium.source.column.length", (Object)"128")});
        Assertions.assertThat((Map)before.schema().field("f1").schema().parameters()).contains(new Map.Entry[]{Assertions.entry((Object)"__debezium.source.column.type", (Object)"FLOAT"), Assertions.entry((Object)"__debezium.source.column.length", (Object)"17")});
        Assertions.assertThat((Map)before.schema().field("f2").schema().parameters()).contains(new Map.Entry[]{Assertions.entry((Object)"__debezium.source.column.type", (Object)"DECIMAL"), Assertions.entry((Object)"__debezium.source.column.length", (Object)"8"), Assertions.entry((Object)"__debezium.source.column.scale", (Object)"4")});
    }

    @Test
    @FixFor(value={"DBZ-3668"})
    public void shouldOutputRecordsInCloudEventsFormat() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.TABLE_INCLUDE_LIST, "testdb.informix.tablea")).build();
        this.connection.execute(new String[]{"INSERT INTO tablea (id,cola) values (1001, 'DBZ3668')"});
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixConnectorIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tablea = records.recordsForTopic("testdb.informix.tablea");
        Assertions.assertThat((List)tablea).hasSize(1);
        for (SourceRecord record : tablea) {
            CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)record, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)record, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)record, (String)"informix", (String)"testdb", (boolean)false);
        }
        InformixConnectorIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.connection.execute(new String[]{"INSERT INTO tablea (id,cola) VALUES (1002, 'DBZ3668')"});
        records = this.consumeRecordsByTopic(1);
        tablea = records.recordsForTopic("testdb.informix.tablea");
        Assertions.assertThat((List)tablea).hasSize(1);
        for (SourceRecord record : tablea) {
            CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)record, (boolean)false, jsonNode -> Assertions.assertThat((String)jsonNode.get("id").asText()).contains(new CharSequence[]{"commit_lsn:"}));
            CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)record, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)record, (String)"informix", (String)"testdb", (boolean)false);
        }
    }

    private void assertRecord(Struct record, List<SchemaAndValueField> expected) {
        expected.forEach(schemaAndValueField -> schemaAndValueField.assertFor(record));
    }
}

