/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.DebeziumException;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.ValueConverter;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformixDefaultValueConverter
implements DefaultValueConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformixDefaultValueConverter.class);
    private final InformixValueConverters valueConverters;
    private final Map<Integer, DefaultValueConverter.DefaultValueMapper> defaultValueMappers;

    public InformixDefaultValueConverter(InformixValueConverters valueConverters, InformixConnection jdbcConnection) {
        this.valueConverters = valueConverters;
        this.defaultValueMappers = Collections.unmodifiableMap(InformixDefaultValueConverter.createDefaultValueMappers(jdbcConnection));
    }

    public Optional<Object> parseDefaultValue(Column column, String defaultValue) {
        LOGGER.info("Parsing default value for column '{}' with expression '{}'", (Object)column.name(), (Object)defaultValue);
        int dataType = column.jdbcType();
        DefaultValueConverter.DefaultValueMapper mapper = this.defaultValueMappers.get(dataType);
        if (mapper == null) {
            LOGGER.warn("Mapper for type '{}' not found.", (Object)dataType);
            return Optional.empty();
        }
        try {
            Object rawDefaultValue = mapper.parse(column, defaultValue != null ? defaultValue.trim() : defaultValue);
            Object convertedDefaultValue = this.convertDefaultValue(rawDefaultValue, column);
            if (convertedDefaultValue instanceof Struct) {
                LOGGER.warn("Struct can't be used as default value for column '{}', will use null instead.", (Object)column.name());
                return Optional.empty();
            }
            return Optional.ofNullable(convertedDefaultValue);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse column default value '{}' to type '{}'.  Expression evaluation is not supported.", new Object[]{defaultValue, dataType, e});
            LOGGER.debug("Parsing failed due to error", (Throwable)e);
            return Optional.empty();
        }
    }

    private Object convertDefaultValue(Object defaultValue, Column column) {
        SchemaBuilder schemaBuilder;
        if (this.valueConverters != null && defaultValue != null && (schemaBuilder = this.valueConverters.schemaBuilder(column)) != null) {
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), -1, schema);
            ValueConverter valueConverter = this.valueConverters.converter(column, field);
            return valueConverter.convert(defaultValue);
        }
        return defaultValue;
    }

    private static Map<Integer, DefaultValueConverter.DefaultValueMapper> createDefaultValueMappers(InformixConnection connection) {
        HashMap<Integer, DefaultValueConverter.DefaultValueMapper> result = new HashMap<Integer, DefaultValueConverter.DefaultValueMapper>();
        result.put(16, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.booleanDefaultValueMapper()));
        result.put(-5, InformixDefaultValueConverter.nullableDefaultValueMapper());
        result.put(2, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.numericDefaultValueMapper()));
        result.put(4, InformixDefaultValueConverter.nullableDefaultValueMapper());
        result.put(5, InformixDefaultValueConverter.nullableDefaultValueMapper());
        result.put(3, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.numericDefaultValueMapper()));
        result.put(8, InformixDefaultValueConverter.nullableDefaultValueMapper((c, v) -> Double.parseDouble(v)));
        result.put(6, InformixDefaultValueConverter.nullableDefaultValueMapper((c, v) -> Double.parseDouble(v)));
        result.put(7, InformixDefaultValueConverter.nullableDefaultValueMapper((c, v) -> Float.valueOf(Float.parseFloat(v))));
        result.put(91, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.castTemporalFunctionCall(connection, 91)));
        result.put(92, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.castTemporalFunctionCall(connection, 92)));
        result.put(93, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.castTemporalFunctionCall(connection, 93)));
        result.put(1, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.enforceCharFieldPadding()));
        result.put(12, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.enforceStringUnquote()));
        result.put(-1, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.enforceStringUnquote()));
        result.put(-15, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.enforceCharFieldPadding()));
        result.put(-9, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.enforceStringUnquote()));
        result.put(-16, InformixDefaultValueConverter.nullableDefaultValueMapper(InformixDefaultValueConverter.enforceStringUnquote()));
        return result;
    }

    private static DefaultValueConverter.DefaultValueMapper nullableDefaultValueMapper() {
        return InformixDefaultValueConverter.nullableDefaultValueMapper(null);
    }

    private static DefaultValueConverter.DefaultValueMapper nullableDefaultValueMapper(DefaultValueConverter.DefaultValueMapper mapper) {
        return (column, value) -> {
            if ("NULL".equalsIgnoreCase(value)) {
                return null;
            }
            if (mapper != null) {
                return mapper.parse(column, value);
            }
            return value;
        };
    }

    public static DefaultValueConverter.DefaultValueMapper booleanDefaultValueMapper() {
        return (column, value) -> {
            if ("t".equals(value.trim())) {
                return true;
            }
            if ("f".equals(value.trim())) {
                return false;
            }
            return Boolean.parseBoolean(value.trim());
        };
    }

    public static DefaultValueConverter.DefaultValueMapper numericDefaultValueMapper() {
        return (column, value) -> {
            BigDecimal decimal = new BigDecimal(value);
            return column.scale().map(decimal::setScale).orElseGet(decimal::toBigIntegerExact);
        };
    }

    private static DefaultValueConverter.DefaultValueMapper castTemporalFunctionCall(InformixConnection connection, int jdbcType) {
        return (column, value) -> {
            if ("TODAY".equalsIgnoreCase(value.trim())) {
                return column.isOptional() ? null : Date.valueOf("1970-01-01");
            }
            if ("CURRENT".equalsIgnoreCase(value.trim()) || "SYSDATE".equalsIgnoreCase(value.trim())) {
                String[] typeExpr = column.typeExpression().trim().split("[\\s()]");
                StringBuilder dateTimeStr = new StringBuilder("1970-01-01 00:00:00");
                if ("DATETIME".equalsIgnoreCase(typeExpr[0])) {
                    int scale;
                    switch (typeExpr.length) {
                        case 5: {
                            scale = Integer.parseInt(typeExpr[4]);
                            break;
                        }
                        case 4: {
                            scale = "FRACTION".equalsIgnoreCase(typeExpr[3]) ? 3 : 0;
                            break;
                        }
                        case 2: {
                            scale = Integer.parseInt(typeExpr[1]);
                            break;
                        }
                        default: {
                            scale = 3;
                        }
                    }
                    if (scale > 0) {
                        dateTimeStr.append('.').append("0".repeat(scale));
                    }
                }
                String defaultVal = dateTimeStr.toString();
                return column.isOptional() ? null : Timestamp.valueOf(defaultVal);
            }
            switch (jdbcType) {
                case 91: {
                    return JdbcConnection.querySingleValue((Connection)connection.connection(), (String)("SELECT DATE('" + value + "') FROM sysmaster:sysdual"), st -> {}, rs -> rs.getDate(1));
                }
                case 92: 
                case 93: {
                    return JdbcConnection.querySingleValue((Connection)connection.connection(), (String)("SELECT DATETIME(" + value + ") " + column.typeExpression().substring(9).toUpperCase() + " FROM sysmaster:sysdual"), st -> {}, rs -> rs.getTimestamp(1));
                }
            }
            throw new DebeziumException("Unexpected JDBC type '" + jdbcType + "' for default value resolution: " + value);
        };
    }

    private static DefaultValueConverter.DefaultValueMapper enforceCharFieldPadding() {
        return (column, value) -> value != null ? Strings.pad((String)InformixDefaultValueConverter.unquote(value), (int)column.length(), (char)' ') : null;
    }

    private static DefaultValueConverter.DefaultValueMapper enforceStringUnquote() {
        return (column, value) -> value != null ? InformixDefaultValueConverter.unquote(value) : null;
    }

    private static String unquote(String value) {
        if (value.startsWith("('") && value.endsWith("')")) {
            return value.substring(2, value.length() - 2);
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

