/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.Nullable;
import io.debezium.connector.informix.Lsn;
import java.util.Objects;

public class TxLogPosition
implements Nullable,
Comparable<TxLogPosition> {
    public static final TxLogPosition NULL = new TxLogPosition(Lsn.NULL, Lsn.NULL, -1, Lsn.NULL);
    private final Lsn commitLsn;
    private final Lsn changeLsn;
    private final Integer txId;
    private final Lsn beginLsn;

    public TxLogPosition(Lsn commitLsn, Lsn changeLsn, Integer txId, Lsn beginLsn) {
        this.commitLsn = commitLsn;
        this.changeLsn = changeLsn;
        this.txId = txId;
        this.beginLsn = beginLsn;
    }

    public static TxLogPosition current() {
        return TxLogPosition.valueOf(Lsn.of(0L));
    }

    public static TxLogPosition valueOf(Lsn sequence) {
        return sequence == null || !sequence.isAvailable() ? NULL : TxLogPosition.valueOf(sequence, Lsn.of(0L), sequence);
    }

    public static TxLogPosition valueOf(Lsn commitLsn, Lsn changeLsn, Lsn beginLsn) {
        return TxLogPosition.valueOf(commitLsn, changeLsn, -1, beginLsn);
    }

    public static TxLogPosition valueOf(Lsn commitLsn, Lsn changeLsn, Integer txId, Lsn beginLsn) {
        return new TxLogPosition(commitLsn, changeLsn, txId, beginLsn);
    }

    public static TxLogPosition cloneAndSet(TxLogPosition position, Lsn commitLsn, Lsn changeLsn, Integer txId, Lsn beginLsn) {
        return TxLogPosition.valueOf(commitLsn.compareTo(position.commitLsn) > 0 ? commitLsn : position.commitLsn, changeLsn.compareTo(position.changeLsn) > 0 ? changeLsn : position.changeLsn, txId >= 0 ? txId : position.txId, beginLsn.compareTo(position.beginLsn) > 0 ? beginLsn : position.beginLsn);
    }

    public Lsn getCommitLsn() {
        return this.commitLsn;
    }

    public Lsn getChangeLsn() {
        return this.changeLsn;
    }

    public Integer getTxId() {
        return this.txId;
    }

    public Lsn getBeginLsn() {
        return this.beginLsn;
    }

    public String toString() {
        return this == NULL ? "NULL" : this.commitLsn + ":" + this.changeLsn + ":" + this.txId + ":" + this.beginLsn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxLogPosition that = (TxLogPosition)o;
        return Objects.equals(this.commitLsn, that.commitLsn) && Objects.equals(this.changeLsn, that.changeLsn) && Objects.equals(this.txId, that.txId) && Objects.equals(this.beginLsn, that.beginLsn);
    }

    public int hashCode() {
        return Objects.hash(this.commitLsn, this.changeLsn, this.txId, this.beginLsn);
    }

    @Override
    public int compareTo(TxLogPosition o) {
        int comparison = this.commitLsn.compareTo(o.getCommitLsn());
        return comparison == 0 ? this.changeLsn.compareTo(o.changeLsn) : comparison;
    }

    public boolean isAvailable() {
        return this.changeLsn != null && this.commitLsn != null && this.beginLsn != null && this.txId != null;
    }
}

