/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.Nullable;

public class Lsn
implements Comparable<Lsn>,
Nullable {
    public static final Lsn NULL = new Lsn(-1L);
    private static final long LO_MASK = Long.parseUnsignedLong("00000000ffffffff", 16);
    private static final long HI_MASK = Long.parseUnsignedLong("ffffffff00000000", 16);
    private final Long sequence;

    Lsn(Long sequence) {
        this.sequence = sequence;
    }

    public static Lsn of(String sequence) {
        return sequence == null || sequence.equalsIgnoreCase("NULL") ? NULL : Lsn.of(Long.parseLong(sequence));
    }

    public static Lsn of(Long sequence) {
        return sequence == null ? NULL : new Lsn(sequence);
    }

    public static Lsn of(long loguniq, long logpos) {
        return Lsn.of((loguniq << 32) + logpos);
    }

    public boolean isAvailable() {
        return this.sequence != null && this.sequence >= 0L;
    }

    public String toString() {
        return Long.toString(this.sequence);
    }

    public String toLongString() {
        return String.format("LSN(%d,%x)", this.loguniq(), this.logpos());
    }

    public long logpos() {
        return LO_MASK & this.sequence;
    }

    public long loguniq() {
        return this.sequence >> 32;
    }

    public long sequence() {
        return this.sequence != null ? this.sequence : -1L;
    }

    public int hashCode() {
        return this.sequence.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && this.sequence.equals(((Lsn)obj).sequence);
    }

    @Override
    public int compareTo(Lsn o) {
        if (this == o) {
            return 0;
        }
        if (!this.isAvailable()) {
            if (!o.isAvailable()) {
                return 0;
            }
            return -1;
        }
        if (!o.isAvailable()) {
            return 1;
        }
        return this.sequence.compareTo(o.sequence);
    }
}

